import React from 'react';
import { LayoutDashboard, FlaskConical, Microscope, Database, FileText, LogOut } from 'lucide-react';
import { db } from '../services/mockSupabase';

interface SidebarProps {
  currentView: string;
  setCurrentView: (view: string) => void;
  userEmail?: string;
}

const Sidebar: React.FC<SidebarProps> = ({ currentView, setCurrentView, userEmail }) => {
  const menuItems = [
    { id: 'dashboard', label: 'Dashboard & Warning', icon: LayoutDashboard },
    { id: 'reagens', label: 'Manajemen Reagen', icon: FlaskConical },
    { id: 'alat', label: 'Manajemen Alat', icon: Microscope },
    { id: 'labs', label: 'Data Laboratorium', icon: Database },
    { id: 'doc', label: 'Dokumentasi SQL', icon: FileText },
  ];

  const handleLogout = async () => {
    if (window.confirm("Apakah Anda yakin ingin keluar?")) {
      await db.signOut();
    }
  };

  return (
    <div className="w-64 bg-slate-900 text-white flex flex-col h-screen fixed left-0 top-0 z-10 shadow-xl">
      <div className="p-6 border-b border-slate-700 bg-slate-900 z-20">
        <h1 className="text-xl font-bold tracking-wider text-medical-500 flex items-center gap-2">
           SIM-LAB TLM
        </h1>
        <p className="text-xs text-slate-400 mt-1">Sistem Manajemen Lab</p>
      </div>

      <nav className="flex-1 p-4 space-y-2 overflow-y-auto">
        {menuItems.map((item) => {
          const Icon = item.icon;
          const isActive = currentView === item.id;
          return (
            <button
              key={item.id}
              onClick={() => setCurrentView(item.id)}
              className={`w-full flex items-center space-x-3 px-4 py-3 rounded-lg transition-all duration-200 ${
                isActive 
                  ? 'bg-medical-600 text-white shadow-lg' 
                  : 'text-slate-300 hover:bg-slate-800 hover:text-white'
              }`}
            >
              <Icon size={20} />
              <span className="font-medium text-sm">{item.label}</span>
            </button>
          );
        })}
      </nav>

      <div className="p-4 border-t border-slate-700 bg-slate-900">
        <div className="flex items-center space-x-3 text-slate-400 mb-4">
          <div className="w-8 h-8 rounded-full bg-medical-500 flex items-center justify-center text-white font-bold text-xs shrink-0">
            {userEmail ? userEmail.substring(0, 2).toUpperCase() : 'AD'}
          </div>
          <div className="overflow-hidden">
            <p className="text-sm font-medium text-white truncate">{userEmail || 'Admin'}</p>
            <p className="text-xs text-slate-500 truncate">Administrator</p>
          </div>
        </div>
        
        <button 
          onClick={handleLogout}
          className="w-full flex items-center justify-center space-x-2 px-4 py-2 bg-slate-800 hover:bg-rose-900/50 hover:text-rose-400 text-slate-400 rounded-lg transition-colors text-sm"
        >
          <LogOut size={16} />
          <span>Keluar</span>
        </button>
      </div>
    </div>
  );
};

export default Sidebar;