const {  default: makeWASocket,Browsers, fetchLatestBaileysVersion, DisconnectReason,downloadMediaMessage ,isJidBroadcast, makeInMemoryStore, useMultiFileAuthState } = require('@whiskeysockets/baileys');
const { writeFile } = require ('fs/promises');
const { Boom } = require('@hapi/boom');
const log = (pino = require("pino"));
const fs = require('fs');
const { createReadStream } = require('fs');
const readline = require('readline');
const fileUpload = require('express-fileupload');
const qr_image = require('qr-image');
const path = require('path');
const { users } = require('../models');
const {whatsapp_auto_replies} = require('../models');
const { media_data_details } = require('../models');
const Sequelize = require('sequelize');
const config = require('../config/config.js');
const sequelize = new Sequelize(config.development);
const { Op, QueryTypes  } = require('sequelize');
const { customers } = require('../models');
const sharp = require('sharp');
const { getMessageType, getMessageDocumentPath, getProfilePicture, checkNumberExist } = require('../model/chat_model');
const { notifications } = require('../models');
const { sessions } = require('../models');
const { broadcasts ,group ,customer_group, broadcast_logs } =  require('../models');
const { auto_replies } = require('../models');
const { messages: chat_messages } = require('../models');
const schedule = require('node-schedule');
const ongoingProcesses = {};
const scheduledJobs = {}; 
const { user_chat_accesses } = require('../models');
const {auto_reply_details} = require('../models');
const { devices } = require('../models');
const { companies } = require('../models');
const jwt = require('jsonwebtoken');
const dotenv = require('dotenv');
const { jobs_broadcasts: jobs } = require('../models');
const {package_groups} = require('../models');
const { package_group_features, package_features } = require('../models');
const { chats } = require('../models');
const { chat_numbers } = require('../models');
const http = require('http');
const https = require('https');
const crypto = require('crypto-js');
const { encrypt, decrypt } = require('../helper/encryption');
const { updateDeviceStatusToInactive } = require('../helper/device');
const { chat_sender_details } = require('../models');
const { chat_sync_logs } = require('../models');
const { user_group } = require('../models');
const { chat_history_users } = require('../models');
const { chat_admin_response_times } = require('../models');

dotenv.config();
const secretKey = process.env.ENCRYPTION_KEY;
let store;

const isConnected = () => {
    return (sock.user);
};

const ensureMediaFolderExists = () => {
    const mediaFolderPath = path.join(__dirname, '../media');
    if (!fs.existsSync(mediaFolderPath)) {
        fs.mkdirSync(mediaFolderPath);
    }
};

ensureMediaFolderExists();

let sock;
let qr;
let soket;
const MAX_RETRIES = 3;


const sockets = {};
let stores = {};

const { Mutex } = require('async-mutex');
const { response } = require('express');
const { type } = require('os');
const mutex = new Mutex();

let connections = {}; 

//ini buat encrypt data file
const encryptData = (data, secretKey) => {
    return crypto.AES.encrypt(JSON.stringify(data), secretKey).toString();
};

//ini buat decrypt data file
const decryptData = (ciphertext, secretKey) => {
    try {
        const bytes = crypto.AES.decrypt(ciphertext, secretKey);
        const decryptedData = bytes.toString(crypto.enc.Utf8);
        return JSON.parse(decryptedData);
    } catch (error) {
        console.error("Error decrypting data:", error);
        return null;
    }
};

//ini buat read encrypted file
const readEncryptedFile = (filePath, secretKey) => {
    try {
        if (fs.existsSync(filePath)) {
            const encryptedData = fs.readFileSync(filePath, 'utf8');
            return decryptData(encryptedData, secretKey);
        }
    } catch (error) {
        console.error("Error reading encrypted file:", error);
    }
    return null;
};

//ini buat write encrypted file
const writeEncryptedFile = (filePath, data, secretKey) => {
    try {
        const encryptedData = encryptData(data, secretKey);
        fs.writeFileSync(filePath, encryptedData, 'utf8');
    } catch (error) {
        console.error("Error writing encrypted file:", error);
    }
};

//ini buat read test data encrypted file
async function readDataEncryptedFile(req, res) {
    const storeFileName = `6285881594312@s.whatsapp.net.json`;
    const storePath = path.join(__dirname, '../backup', storeFileName);

    const memoryBefore = process.memoryUsage();
    console.log(`Memory usage before reading file: ${JSON.stringify(memoryBefore)}`);
    const storeData = readEncryptedFile(storePath, secretKey);

    const memoryAfter = process.memoryUsage();
    console.log(`Memory usage after reading file: ${JSON.stringify(memoryAfter)}`);

    if (storeData) {
        res.status(200).json(storeData);
    } else {
        res.status(404).json({ error: 'Data not found' });
    }
}

//buat scan qr code
async function initializeConnection(token) {
    if (connections[token]) {
        return connections[token];
    }

    connections[token] = new Promise(async (resolve, reject) => {
        try {
            const { state, saveCreds } = await useMultiFileAuthState('session/' + token);
            let { version, isLatest } = await fetchLatestBaileysVersion();
            const storeFileName = `${token}.json`;
            const storePath = path.join(__dirname, '../backup', storeFileName);

            stores[token] = makeInMemoryStore({});

            const storeData = readEncryptedFile(storePath, secretKey);
            if (storeData) {
                stores[token].fromJSON(storeData);
            }

            const sock = makeWASocket({
                printQRInTerminal: true,
                auth: state,
                logger: log({ level: "silent" }),
                version,
                browser: Browsers.windows('chrome'),
            });

            stores[token].bind(sock.ev);
            sock.multi = true;
            sockets[token] = sock;
            

            sock.ev.on('connection.update', async (update) => {
                const { connection, lastDisconnect, qr } = update;

                if (qr) {
                    resolve(qr);
                    return;
                }

                if (connection === 'close') {
                    let reason = new Boom(lastDisconnect.error).output.statusCode;
                    connections[token] = null;
                    if (reason === DisconnectReason.connectionClosed || reason === DisconnectReason.connectionLost || reason === DisconnectReason.restartRequired || reason === DisconnectReason.timedOut) {
                        connectToWhatsApp(token);
                    } else if (reason === DisconnectReason.connectionReplaced || reason === DisconnectReason.loggedOut) {
                        sock.end(new Boom('Reconnecting due to connection issue', { statusCode: reason }));
                    } else {
                        sock.end(`Unknown DisconnectReason: ${reason}|${lastDisconnect.error}`);
                    }
                }

                if (connection === 'open') {
                    console.log('Opened connection1');
                }

            });

            sock.ev.on("creds.update", saveCreds);
          
            sock.ev.on("messages.upsert", async ({ messages, type }) => {
    
                if (type === "notify") {
                    for (const message of messages) {
                        if (!message.key.fromMe && message.key.remoteJid.endsWith('@s.whatsapp.net')) {
                            const remoteJid = message.key.remoteJid;
                            const conversation = message.message.conversation.toLowerCase();
                        }
                    }
                }

                console.log("Messages upsert:", messages);

                writeEncryptedFile(storePath, stores[token].toJSON(), secretKey);
            });

            stores[token].bind(sock.ev);

            

          

        } catch (err) {
            console.log("Error in createWhatsAppSession:", err);
            reject(err);
        }
    });

    return connections[token];
}

//clear session in process memory
async function cleanupSession(token) {
    console.log(`Cleaning up session for token: ${token}`);
    delete retryCounts[token];
    delete sockets[token];

    const sessionDir = `./session/${token}`;
    if (fs.existsSync(sessionDir)) {
        fs.rmdirSync(sessionDir, { recursive: true });
    }

    const device = await devices.findOne({ where: { session: encrypt(token) } });
    if (device) {
        await device.update({ status: 'Inactive' });
    } else {
        console.log('Device not found');
    }
}

const retryCounts = {};
const non401RetryCounts = {};
const maxRetries = 5;
const non401MaxRetries = 3;

const pLimit = require('p-limit');
const CONCURRENT_LIMIT = 5; 

async function connectToWhatsApp(token) {
    const session_encrypted = encrypt(token);
    console.log("Connecting to WhatsApp with token:", token);

    try {
        const session = { "session": token };
        const { state, saveCreds } = await useMultiFileAuthState('session/' + token);
        const { version, isLatest } = await fetchLatestBaileysVersion();

        const storeFileName = `${token}.json`;
        const storePath = `./backup/${storeFileName}`;

        const contacts = {};
        stores[token] = makeInMemoryStore({});
        const storeData = readEncryptedFile(storePath, secretKey);
        if (storeData) {
            stores[token].fromJSON(storeData);
        }

        const sock = makeWASocket({
            printQRInTerminal: false,
            auth: state,
            logger: log({ level: "silent" }),
            version,
            shouldIgnoreJid: jid => isJidBroadcast(jid),
            browser: Browsers.windows('chrome'),
            syncFullHistory: true,
            defaultQueryTimeoutMs: undefined,
            shouldSyncHistoryMessage: message => {
                console.log("Sync progress:", message.progress);
                updateSyncProgress(token, message.progress);
                return message;
            }
        });

        stores[token].bind(sock.ev);
        sock.multi = true;
        sockets[token] = sock;

        function updateSyncProgress(token, progress) {
            const device = devices.findOne({ where: { session: session_encrypted } });
            if (device) {
                console.log('Updating sync progress:', progress);
                if (progress === 100) {
                    setTimeout(() => {
                        devices.update({ sync_progress: 100 }, { where: { session: session_encrypted } });
                        console.log('Sync progress updated to 100% after 10 minutes');
                    }, 600000); // 10 minutes in milliseconds
                }
            } else {
                console.log('Device not found');
            }
        }

        sock.ev.on('connection.update', async (update) => {
            const { connection, lastDisconnect } = update;

            if (connection === 'close') {
                let reason = new Boom(lastDisconnect.error).output.statusCode;
                connections[token] = null;

                if (!retryCounts[token]) {
                    retryCounts[token] = 0;
                }
                if (!non401RetryCounts[token]) {
                    non401RetryCounts[token] = 0;
                }

                console.log("Reason:", reason);

                if (reason === 401) {
                    console.log('Stopping connection attempts due to 401 error');
                    await cleanupSession(token);
                } else if (retryCounts[token] < maxRetries) {
                    if ([DisconnectReason.connectionClosed, DisconnectReason.connectionLost, DisconnectReason.restartRequired, DisconnectReason.timedOut, DisconnectReason.connectionReplaced, DisconnectReason.loggedOut].includes(reason)) {
                        retryCounts[token]++;
                        console.log(`Retrying to connect... (${retryCounts[token]}/${maxRetries})`);
                        await new Promise(resolve => setTimeout(resolve, 1000));
                        connectToWhatsApp(token);
                    } else if (non401RetryCounts[token] < non401MaxRetries) {
                        non401RetryCounts[token]++;
                        console.log(`Retrying to connect due to non-401 reason... (${non401RetryCounts[token]}/${non401MaxRetries})`);
                        await new Promise(resolve => setTimeout(resolve, 1000));
                        connectToWhatsApp(token);
                    } else {
                        console.log('Stopping connection attempts after maximum retries for non-401 reasons');
                        await cleanupSession(token);
                        delete non401RetryCounts[token];
                    }
                } else {
                    console.log('Stopping connection attempts after maximum retries');
                    await cleanupSession(token);
                    delete retryCounts[token];
                }

            } else if (connection === 'open') {
                retryCounts[token] = 0;
                non401RetryCounts[token] = 0;
                console.log('Opened connection' + token);

                const device = await devices.findOne({ where: { session: session_encrypted } });
                if (device) {
                    // await devices.update({ status: 'Active', date_connected: new Date() }, { where: { session: session_encrypted } });
                    await device.update({ status: 'Active', date_connected: new Date() });
                } else {
                    console.log('Device not found');
                }
            }
        });

        
        sock.ev.on("messages.upsert", async ({ messages, type }) => {
            const pLimit = await import('p-limit').then(module => module.default);
            const limit = pLimit(CONCURRENT_LIMIT);
        
            const tasks = messages.map(m => limit(() => chatDatProcess(m)));
            await Promise.all(tasks);
        
            if (type === "notify") {
                await handleNotifications(messages);
            }
        });
        
        async function chatDatProcess(m) {
            if (!m.message) return;
        
            const device = await devices.findOne({ where: { session: session_encrypted } });
            const messageType = Object.keys(m.message);
        
            if (messageType.includes('imageMessage')) {
                await handleMediaMessage(m, 'image', 'jpeg', m.message.imageMessage.fileLength.low);
            } else if (messageType.includes('videoMessage')) {
                await handleMediaMessage(m, 'video', 'mp4', m.message.videoMessage.fileLength.low);
            } else if (messageType.includes('documentMessage')) {
                await handleDocumentMessage(m, m.message.documentMessage.fileName, m.message.documentMessage.fileLength.low);
            } else if (messageType.includes('documentWithCaptionMessage')) {
                const documentMessage = m.message.documentWithCaptionMessage.message.documentMessage;
                await handleDocumentMessage(m, documentMessage.fileName, documentMessage.fileLength.low);
            } else if (messageType.includes('stickerMessage')) {
                await handleMediaMessage(m, 'sticker', 'webp', m.message.stickerMessage.fileLength.low);
            } else if (messageType.includes('audioMessage')) {
                await handleMediaMessage(m, 'audio', 'mp3', m.message.audioMessage.fileLength.low);
            } else {
             
            }
        }
        
        async function handleMediaMessage(m, type, extension, fileLength, retries = 0) {
            try {
                const buffer = await downloadMediaMessage(m, 'buffer', {}, { logger: log({ level: "silent" }), reuploadRequest: sock.updateMediaMessage });
                console.log("Buffer:", buffer);
                await writeFile(path.join(__dirname, '../media', `${m.key.id}.${extension}`), buffer);
        
                const device = await devices.findOne({ where: { session: session_encrypted } });

                await media_data_details.create({
                    media_data_name: `${m.key.id}.${extension}`,
                    media_data_size: fileLength / 1024,
                    number_jid : encrypt(m.key.remoteJid),
                    type,
                    id_messsage: m.key.id,
                    date: new Date(),
                    createdAt: new Date(),
                    origin_media_name: null,
                    origin_media_url: null,
                    updatedAt: new Date(),
                    company_id: device.company_id,
                    session: encrypt(token)
                });
            } catch (error) {
                if (retries < MAX_RETRIES) {
                    console.log(`Retrying download for ${m.key.id} (${retries + 1}/${MAX_RETRIES})`);
                    await handleMediaMessage(m, type, extension, fileLength, retries + 1);
                } else {
                    console.error(`Failed to download media after ${MAX_RETRIES} attempts`, error);
                }
            }
        }
        
        async function handleDocumentMessage(m, fileName, fileLength, retries = 0) {
            try {
                console.log("File name:", fileName);
                const buffer = await downloadMediaMessage(m, 'buffer', {}, { logger: log({ level: "silent" }), reuploadRequest: sock.updateMediaMessage });
                const mediaFolderPath = path.join(__dirname, '../media');
                if (!fs.existsSync(mediaFolderPath)) fs.mkdirSync(mediaFolderPath);
        
                await writeFile(path.join(__dirname, '../media', `${m.key.id} - ${fileName}`), buffer);
        
                const device = await devices.findOne({ where: { session: session_encrypted } });
                await media_data_details.create({
                    media_data_name: `${m.key.id} - ${fileName}`,
                    media_data_size: fileLength / 1024,
                    date: new Date(),
                    number_jid: encrypt(m.key.remoteJid),
                    type: 'document',
                    id_messsage: m.key.id,
                    createdAt: new Date(),
                    updatedAt: new Date(),
                    company_id: device.company_id,
                    session: encrypt(token)
                });
            } catch (error) {
                if (retries < MAX_RETRIES) {
                    console.log(`Retrying download for ${m.key.id} (${retries + 1}/${MAX_RETRIES})`);
                    await handleDocumentMessage(m, fileName, fileLength, retries + 1);
                } else {
                    console.error(`Failed to download document after ${MAX_RETRIES} attempts`, error);
                }
            }
        }
        
        //START AUTOREPLY DAN AWAY MESSAGE
        async function handleNotifications(messages) {
            const receiver_number = token.split('@')[0];
            const encryptedReceiverNumber = encrypt(receiver_number);

            
          
            for (const message of messages) {
                const chat = await chats.findOne({ where: { message_id: message.key.id } });

                let new_status = message.status;
                if (chat){
                    await chats.update({ status: new_status }, { where: { message_id: message.key.id } });
                }

                if (!message.key.fromMe && message.key.remoteJid.endsWith('@s.whatsapp.net')) {
                    const remoteJid = message.key.remoteJid;
                    const conversation = message.message.conversation
                        ? message.message.conversation.toLowerCase()
                        : message.message.extendedTextMessage
                        ? message.message.extendedTextMessage.text.toLowerCase()
                        : null;
        
                    if (!conversation) {
                        console.log("No conversation text found in the message.");
                        continue;
                    }
        
                    try {
                        const device = await devices.findOne({ where: { session: session_encrypted } });
                        
                        const company = await companies.findOne({ where: { id: device.company_id } });
                        // const startTime = company.start_time;
                        // const endTime = company.end_time;
                        // const currentTime = new Date().toLocaleTimeString('en-US', { hour12: false });
                        //check if start time and end time is null or empty
                        let startTime = company.start_time;
                        let endTime = company.end_time;

                        if (startTime === null || startTime === '') {
                            startTime = null;
                        }
                        if (endTime === null || endTime === '') {
                            endTime = null;
                        }

                        const currentTime = new Date().toLocaleTimeString('en-US', { hour12: false });

                        // const closedMessage = decrypt(company.closed_message);
                        //if closedMesasge not null
                        let closedMessage = null;
                        if (company.closed_message !== null) {
                            closedMessage = decrypt(company.closed_message);
                        }

                        const encryptedRemoteJid = encrypt(remoteJid);

                        const chat_history_user = await chat_history_users.findOne({ where: { customer_number: encryptedRemoteJid , company_id: device.company_id , session: encrypt(token) } });
                        if (!chat_history_user) {
                            await chat_history_users.create({
                                customer_number: encryptedRemoteJid,
                                company_id: device.company_id,
                                session: encrypt(token),
                                createdAt: new Date(),
                                updatedAt: new Date(),
                                status_chat: false
                                
                            });
                       
                            let welcome_message = null;
                            if (company.welcome_message !== null) {
                                welcome_message = decrypt(company.welcome_message);
                                await sock.sendMessage(remoteJid, { text: welcome_message });
                            }

                           
                        }
                        else if(chat_history_user && chat_history_user.status_chat === true){
                            let customer_welcome_message = null;
                            if (company.customer_welcome_message !== null) {
                                customer_welcome_message = decrypt(company.customer_welcome_message);
                                await sock.sendMessage(remoteJid, { text: customer_welcome_message });
                            }
                            await chat_history_users.update({ status_chat: false }, { where: { customer_number: encryptedRemoteJid , company_id: device.company_id , session: encrypt(token) } });
                            
                        }


                        else{
                            if (device && currentTime >= startTime && currentTime <= endTime) {
                                const messages_data = await chat_messages.findAll({ where: { type: true , company_id: device.company_id } });
                                if (messages_data && messages_data.length > 0) {
                                    for (const message_data of messages_data) {
                                        if (company.allocation_status === 'inactive') {
                                            console.log("running active allocation status");
                                            const user_group_data = await user_group.findAll({ where: { company_id: device.company_id } });
                                            if (user_group_data && user_group_data.length > 0) {
                                                const user_ids = user_group_data.map(ug => ug.user_id);
                                                const users_data = await users.findAll({ 
                                                    where: { 
                                                        id: user_ids,
                                                        role: { [Op.not]: 'Admin' } 
                                                    } 
                                                });
                                                
                                                if (users_data && users_data.length > 0) {
                                                    for (const user of users_data) {
                                                        const user_id = user.id;
                                                        const user_phone_number = user.phone_number;
                                                        const encryptedSessionNumber = encrypt(token);
                                                        const encryptedCustomerNumber = encrypt(remoteJid);
                                                        const user_chat_accesses_data = await user_chat_accesses.findOne({ 
                                                            where: { 
                                                                session_number: encryptedSessionNumber, 
                                                                customer_number: encryptedCustomerNumber, 
                                                                user_id 
                                                            } 
                                                        });
                                                        if (!user_chat_accesses_data) {
                                                            await user_chat_accesses.create({
                                                                session_number: encryptedSessionNumber,
                                                                customer_number: encryptedCustomerNumber,
                                                                user_id,
                                                                createdAt: new Date(),
                                                                updatedAt: new Date()
                                                            });
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        
                                        if (company.allocation_status === 'active') {
                                            try {
                                                console.log("running inactive allocation status");
                                                const auto_reply_details_data = await auto_reply_details.findOne({ where: { auto_reply_id: message_data.auto_reply_id } });
                                                
                                                if (auto_reply_details_data && auto_reply_details_data.user_id !== null) {
                                                    const auto_reply_user_id = auto_reply_details_data.user_id;
                                                    const encryptedSessionNumber = encrypt(token);
                                                    const encryptedCustomerNumber = encrypt(remoteJid);
                                                    const user_chat_accesses_data = await user_chat_accesses.findOne({ 
                                                        where: { 
                                                            session_number: encryptedSessionNumber, 
                                                            customer_number: encryptedCustomerNumber, 
                                                            user_id: auto_reply_user_id 
                                                        } 
                                                    });

                                                    if (!user_chat_accesses_data) {
                                                        await user_chat_accesses.create({
                                                            session_number: encryptedSessionNumber,
                                                            customer_number: encryptedCustomerNumber,
                                                            user_id: auto_reply_user_id,
                                                            createdAt: new Date(),
                                                            updatedAt: new Date()
                                                        });
                                                    }
                                                }
                                            } catch (error) {
                                                console.error("Error handling inactive allocation status:", error);
                                            }
                                        }


                                        const decryptedMessage = decrypt(message_data.message);
                                        if (conversation === decryptedMessage) {
                                            const auto_reply = await auto_replies.findOne({ where: { id: message_data.auto_reply_id } });
                                            if (auto_reply && auto_reply.media === null) {
                                                const decryptedReply = decrypt(auto_reply.reply);
                                                console.log("Send Message 1");
                                                await sock.sendMessage(remoteJid, { text: decryptedReply });
                                            }
                                            else if (auto_reply && auto_reply.media !== null) {
                                                const decryptedReply = decrypt(auto_reply.reply);
                                                const name = auto_reply.media;
                                                const media_name = auto_reply.media_name;
                                                const media = auto_reply.media;
                                                const mediaType = name.split('.').pop().toLowerCase();
                                                const filePath = path.join(__dirname, '../uploads', media);
                                                let fileData;

                                                if (['jpg', 'jpeg', 'png'].includes(mediaType)) {
                                                    console.log("Media type:", mediaType);
                                                    fileData = { image: { url: filePath }, caption: decryptedReply };
                                                } else if (mediaType === 'mp4') {
                                                    fileData = { video: { url: filePath }, caption: decryptedReply };
                                                } else if (mediaType === 'pdf') {
                                                    fileData = { document: { url: filePath }, mimetype: 'application/pdf', fileName: media_name, caption: decryptedReply };
                                                } else if (mediaType === 'xlsx') {
                                                    fileData = { document: { url: filePath }, mimetype: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', fileName: media_name, caption: decryptedReply };
                                                } else if (mediaType === 'docx') {
                                                    fileData = { document: { url: filePath }, mimetype: 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', fileName: media_name, caption: decryptedReply };
                                                } else if (mediaType === 'csv') {
                                                    fileData = { document: { url: filePath }, mimetype: 'text/csv' };
                                                } else {
                                                    fileData = { document: { url: filePath }, mimetype: 'application/octet-stream', caption: decryptedReply , fileName: media_name };
                                                }
                                                console.log("Send Message");
                                                await sock.sendMessage(remoteJid, fileData);
                                            }
                                        }
                                    }
                                }
                                const messages_data_false = await chat_messages.findAll({ where: { type: false , company_id: device.company_id } });
                                if (messages_data_false) {
                                    for (const message_data of messages_data_false) {
                                       
                                        
                                        const decryptedMessage = decrypt(message_data.message);
                                        const conversation_lower = conversation.toLowerCase();
                                        
                                        if(message_data.is_split === true){
                                         
                                            const keywords = decryptedMessage.toLowerCase().split(" ")
                                            const conversations = conversation_lower.split(" ")
                                            counter = 0;
                                          
                                            for (let i = 0; i < keywords.length; i++){
                                                for (let j = 0; j < conversations.length; j++){
                                                    // if (keywords[i].includes(conversations[j])){
                                                    if(conversations[j].includes(keywords[i])){
                                                        counter++;
                                                        
                                                    }
                                                }
                                            }
                                         
                                            if (counter === keywords.length){
                                                const auto_reply = await auto_replies.findOne({ where: { id: message_data.auto_reply_id } });
                                                if (auto_reply && auto_reply.media === null) {
                                                    const decryptedReply = decrypt(auto_reply.reply);
                                                    console.log("Send Message 2");
                                                    await sock.sendMessage(remoteJid, { text: decryptedReply });
                                                } else if (auto_reply && auto_reply.media !== null) {
                                                    const decryptedReply = decrypt(auto_reply.reply);
                                                    const name = auto_reply.media;
                                                    const media = auto_reply.media;
                                                    const media_name = auto_reply.media_name;
                                                    const mediaType = name.split('.').pop().toLowerCase();
                                                    const filePath = path.join(__dirname, '../uploads', media);
                                                    let fileData;
                                    
                                                    if (['jpg', 'jpeg', 'png'].includes(mediaType)) {
                                                        console.log("Media type:", mediaType);
                                                        fileData = { image: { url: filePath }, caption: decryptedReply };
                                                    } else if (mediaType === 'mp4') {
                                                        fileData = { video: { url: filePath }, caption: decryptedReply };
                                                    } else if (mediaType === 'pdf') {
                                                        fileData = { document: { url: filePath }, mimetype: 'application/pdf', fileName: media_name, caption: decryptedReply };
                                                    } else if (mediaType === 'xlsx') {
                                                        fileData = { document: { url: filePath }, mimetype: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', fileName: media_name, caption: decryptedReply };
                                                    } else if (mediaType === 'docx') { 
                                                        fileData = { document: { url: filePath }, mimetype: 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', fileName: media_name, caption: decryptedReply };
                                                    } else if (mediaType === 'csv') {
                                                        fileData = { document: { url: filePath }, mimetype: 'text/csv' , fileName: media_name };
                                                    } else {
                                                        fileData = { document: { url: filePath }, mimetype: 'application/octet-stream', caption: decryptedReply , fileName: media_name };
                                                    }
                                                    console.log("Send Message 3");
                                                    await sock.sendMessage(remoteJid, fileData);
                                                }
                                            }
                                            if ( company.allocation_status === 'inactive') {
                                                const user_group_data = await user_group.findAll({ where: { company_id: device.company_id } });
                                                
                                                if (user_group_data && user_group_data.length > 0) {
                                                    const user_ids = user_group_data.map(ug => ug.user_id);
                                                    const users_data = await users.findAll({ 
                                                        where: { 
                                                            id: user_ids,
                                                            role: { [Op.not]: 'Admin' } 
                                                        } 
                                                    });
                                                    
                                                    if (users_data && users_data.length > 0) {
                                                        for (const user of users_data) {
                                                            const user_id = user.id;
                                                            const user_phone_number = user.phone_number;
                                                            const encryptedSessionNumber = encrypt(token);
                                                            const encryptedCustomerNumber = encrypt(remoteJid);
                                                            const user_chat_accesses_data = await user_chat_accesses.findOne({ 
                                                                where: { 
                                                                    session_number: encryptedSessionNumber, 
                                                                    customer_number: encryptedCustomerNumber, 
                                                                    user_id 
                                                                } 
                                                            });
                                            
                                                            if (!user_chat_accesses_data) {
                                                                await user_chat_accesses.create({
                                                                    session_number: encryptedSessionNumber,
                                                                    customer_number: encryptedCustomerNumber,
                                                                    user_id,
                                                                    createdAt: new Date(),
                                                                    updatedAt: new Date()
                                                                });
                                                            }
                                                        }
                                                    }
                                                }
                                            }

                                            if (company.allocation_status === 'active') {
                                                try {
                                                    const auto_reply_details_data = await auto_reply_details.findOne({ where: { auto_reply_id: message_data.auto_reply_id } });
                                                    
                                                    if (auto_reply_details_data && auto_reply_details_data.user_id !== null) {
                                                        const auto_reply_user_id = auto_reply_details_data.user_id;
                                                        const encryptedSessionNumber = encrypt(token);
                                                        const encryptedCustomerNumber = encrypt(remoteJid);
                                            
                                                        const user_chat_accesses_data = await user_chat_accesses.findOne({ 
                                                            where: { 
                                                                session_number: encryptedSessionNumber, 
                                                                customer_number: encryptedCustomerNumber, 
                                                                user_id : auto_reply_user_id
                                                            } 
                                                        });

                                                        if (!user_chat_accesses_data) {
                                                            await user_chat_accesses.create({
                                                                session_number: encryptedSessionNumber,
                                                                customer_number: encryptedCustomerNumber,
                                                                user_id : auto_reply_user_id,
                                                                createdAt: new Date(),
                                                                updatedAt: new Date()
                                                            });
                                                        }
                                                    }
                                                }
                                                catch (error) {
                                                    console.error("Error handling inactive allocation status:", error);
                                                }
                                            }
                                        } 
                                        else if(message_data.is_split === false){
                                            if (conversation_lower.includes(decryptedMessage)) {
                                                if ( company.allocation_status === 'inactive') {
                                                    const user_group_data = await user_group.findAll({ where: { company_id: device.company_id } });
                                                    
                                                    if (user_group_data && user_group_data.length > 0) {
                                                        const user_ids = user_group_data.map(ug => ug.user_id);
                                                        const users_data = await users.findAll({ 
                                                            where: { 
                                                                id: user_ids,
                                                                role: { [Op.not]: 'Admin' } 
                                                            } 
                                                        });
                                                        
                                                        if (users_data && users_data.length > 0) {
                                                            for (const user of users_data) {
                                                                const user_id = user.id;
                                                                const user_phone_number = user.phone_number;
                                                                const encryptedSessionNumber = encrypt(token);
                                                                const encryptedCustomerNumber = encrypt(remoteJid);
                                                                const user_chat_accesses_data = await user_chat_accesses.findOne({ 
                                                                    where: { 
                                                                        session_number: encryptedSessionNumber, 
                                                                        customer_number: encryptedCustomerNumber, 
                                                                        user_id 
                                                                    } 
                                                                });
                                                
                                                                if (!user_chat_accesses_data) {
                                                                    await user_chat_accesses.create({
                                                                        session_number: encryptedSessionNumber,
                                                                        customer_number: encryptedCustomerNumber,
                                                                        user_id,
                                                                        createdAt: new Date(),
                                                                        updatedAt: new Date()
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    }
                                                }

                                                if (company.allocation_status === 'active') {
                                                    try {
                                                        const auto_reply_details_data = await auto_reply_details.findOne({ where: { auto_reply_id: message_data.auto_reply_id } });
                                                        
                                                        if (auto_reply_details_data && auto_reply_details_data.user_id !== null) {
                                                            const auto_reply_user_id = auto_reply_details_data.user_id;
                                                            const encryptedSessionNumber = encrypt(token);
                                                            const encryptedCustomerNumber = encrypt(remoteJid);
                                                
                                                            const user_chat_accesses_data = await user_chat_accesses.findOne({ 
                                                                where: { 
                                                                    session_number: encryptedSessionNumber, 
                                                                    customer_number: encryptedCustomerNumber, 
                                                                    user_id : auto_reply_user_id
                                                                } 
                                                            });

                                                            if (!user_chat_accesses_data) {
                                                                await user_chat_accesses.create({
                                                                    session_number: encryptedSessionNumber,
                                                                    customer_number: encryptedCustomerNumber,
                                                                    user_id : auto_reply_user_id,
                                                                    createdAt: new Date(),
                                                                    updatedAt: new Date()
                                                                });
                                                            }
                                                        }
                                                    }
                                                    catch (error) {
                                                        console.error("Error handling inactive allocation status:", error);
                                                    }
                                                }

                                                
                                                const auto_reply = await auto_replies.findOne({ where: { id: message_data.auto_reply_id } });
                                                if (auto_reply && auto_reply.media === null) {
                                                    const decryptedReply = decrypt(auto_reply.reply);
                                                    console.log("Send Message 4");
                                                    await sock.sendMessage(remoteJid, { text: decryptedReply });
                                                } else if (auto_reply && auto_reply.media !== null) {
                                                    const decryptedReply = decrypt(auto_reply.reply);
                                                    const name = auto_reply.media;
                                                    const media = auto_reply.media;
                                                    const media_name = auto_reply.media_name;
                                                    const mediaType = name.split('.').pop().toLowerCase();
                                                    const filePath = path.join(__dirname, '../uploads', media);
                                                    let fileData;
                                    
                                                    if (['jpg', 'jpeg', 'png'].includes(mediaType)) {
                                                        console.log("Media type:", mediaType);
                                                        fileData = { image: { url: filePath }, caption: decryptedReply };
                                                    } else if (mediaType === 'mp4') {
                                                        fileData = { video: { url: filePath }, caption: decryptedReply };
                                                    } else if (mediaType === 'pdf') {
                                                        fileData = { document: { url: filePath }, mimetype: 'application/pdf', fileName: media_name, caption: decryptedReply };
                                                    } else if (mediaType === 'xlsx') {
                                                        fileData = { document: { url: filePath }, mimetype: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', fileName: media_name, caption: decryptedReply };
                                                    } else if (mediaType === 'docx') { 
                                                        fileData = { document: { url: filePath }, mimetype: 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', fileName: media_name, caption: decryptedReply };
                                                    } else if (mediaType === 'csv') {
                                                        fileData = { document: { url: filePath }, mimetype: 'text/csv' , fileName: media_name };
                                                    } else {
                                                        fileData = { document: { url: filePath }, mimetype: 'application/octet-stream', caption: decryptedReply , fileName: media_name };
                                                    }
                                    
                                                    await sock.sendMessage(remoteJid, fileData);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            
                            
                            if (device && currentTime < startTime || currentTime > endTime) {
                                if (closedMessage !== null) {
                                    await sock.sendMessage(remoteJid, { text: closedMessage });
                                }
                            }
                            if (device && startTime === null && endTime === null) {
                                const messages_data = await chat_messages.findAll({ where: { type: true , company_id: device.company_id } });
                                
                                if (messages_data) {
                                    for (const message_data of messages_data) {
                                        if (company.allocation_status === 'inactive') {
                                            console.log("running active allocation status");
                                            const user_group_data = await user_group.findAll({ where: { company_id: device.company_id } });
                                            if (user_group_data && user_group_data.length > 0) {
                                                const user_ids = user_group_data.map(ug => ug.user_id);
                                                const users_data = await users.findAll({ 
                                                    where: { 
                                                        id: user_ids,
                                                        role: { [Op.not]: 'Admin' } 
                                                    } 
                                                });
                                                
                                                if (users_data && users_data.length > 0) {
                                                    for (const user of users_data) {
                                                        const user_id = user.id;
                                                        const user_phone_number = user.phone_number;
                                                        const encryptedSessionNumber = encrypt(token);
                                                        const encryptedCustomerNumber = encrypt(remoteJid);
                                                        const user_chat_accesses_data = await user_chat_accesses.findOne({ 
                                                            where: { 
                                                                session_number: encryptedSessionNumber, 
                                                                customer_number: encryptedCustomerNumber, 
                                                                user_id 
                                                            } 
                                                        });
                                                        if (!user_chat_accesses_data) {
                                                            await user_chat_accesses.create({
                                                                session_number: encryptedSessionNumber,
                                                                customer_number: encryptedCustomerNumber,
                                                                user_id,
                                                                createdAt: new Date(),
                                                                updatedAt: new Date()
                                                            });
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        
                                        if (company.allocation_status === 'active') {
                                            try {
                                                console.log("running inactive allocation status");
                                                const auto_reply_details_data = await auto_reply_details.findOne({ where: { auto_reply_id: message_data.auto_reply_id } });
                                                
                                                if (auto_reply_details_data && auto_reply_details_data.user_id !== null) {
                                                    const auto_reply_user_id = auto_reply_details_data.user_id;
                                                    const encryptedSessionNumber = encrypt(token);
                                                    const encryptedCustomerNumber = encrypt(remoteJid);
                                                    const user_chat_accesses_data = await user_chat_accesses.findOne({ 
                                                        where: { 
                                                            session_number: encryptedSessionNumber, 
                                                            customer_number: encryptedCustomerNumber, 
                                                            user_id: auto_reply_user_id 
                                                        } 
                                                    });

                                                    if (!user_chat_accesses_data) {
                                                        await user_chat_accesses.create({
                                                            session_number: encryptedSessionNumber,
                                                            customer_number: encryptedCustomerNumber,
                                                            user_id: auto_reply_user_id,
                                                            createdAt: new Date(),
                                                            updatedAt: new Date()
                                                        });
                                                    }
                                                }
                                            } catch (error) {
                                                console.error("Error handling inactive allocation status:", error);
                                            }
                                        }


                                        const decryptedMessage = decrypt(message_data.message);
                                        if (conversation === decryptedMessage) {
                                            const auto_reply = await auto_replies.findOne({ where: { id: message_data.auto_reply_id } });
                                            if (auto_reply && auto_reply.media === null) {
                                                const decryptedReply = decrypt(auto_reply.reply);
                                                await sock.sendMessage(remoteJid, { text: decryptedReply });
                                            }
                                            else if (auto_reply && auto_reply.media !== null) {
                                                const decryptedReply = decrypt(auto_reply.reply);
                                                const name = auto_reply.media;
                                                const media_name = auto_reply.media_name;
                                                const media = auto_reply.media;
                                                const mediaType = name.split('.').pop().toLowerCase();
                                                const filePath = path.join(__dirname, '../uploads', media);
                                                let fileData;

                                                if (['jpg', 'jpeg', 'png'].includes(mediaType)) {
                                                    console.log("Media type:", mediaType);
                                                    fileData = { image: { url: filePath }, caption: decryptedReply };
                                                } else if (mediaType === 'mp4') {
                                                    fileData = { video: { url: filePath }, caption: decryptedReply };
                                                } else if (mediaType === 'pdf') {
                                                    fileData = { document: { url: filePath }, mimetype: 'application/pdf', fileName: media_name, caption: decryptedReply };
                                                } else if (mediaType === 'xlsx') {
                                                    fileData = { document: { url: filePath }, mimetype: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', fileName: media_name, caption: decryptedReply };
                                                } else if (mediaType === 'docx') {
                                                    fileData = { document: { url: filePath }, mimetype: 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', fileName: media_name, caption: decryptedReply };
                                                } else if (mediaType === 'csv') {
                                                    fileData = { document: { url: filePath }, mimetype: 'text/csv' };
                                                } else {
                                                    fileData = { document: { url: filePath }, mimetype: 'application/octet-stream', caption: decryptedReply , fileName: media_name };
                                                }

                                                await sock.sendMessage(remoteJid, fileData);
                                            }
                                        }
                                    }
                                }
                                const messages_data_false = await chat_messages.findAll({ where: { type: false , company_id: device.company_id } });
                                if (messages_data_false) {
                                    for (const message_data of messages_data_false) {
                                        const decryptedMessage = decrypt(message_data.message);
                                        const conversation_lower = conversation.toLowerCase();
                                     
                                        if(message_data.is_split === true){
                                           
                                            
                                            const keywords = decryptedMessage.toLowerCase().split(" ")
                                            const conversations = conversation_lower.split(" ")
                                            counter = 0;
                                          
                                            for (let i = 0; i < keywords.length; i++){
                                                for (let j = 0; j < conversations.length; j++){
                                                    // if (keywords[i].includes(conversations[j])){
                                                    if(conversations[j].includes(keywords[i])){
                                                        counter++;
                                                      
                                                    }
                                                }
                                            }
                                          
                                            if (counter === keywords.length){
                                                const auto_reply = await auto_replies.findOne({ where: { id: message_data.auto_reply_id } });
                                                if (auto_reply && auto_reply.media === null) {
                                                    const decryptedReply = decrypt(auto_reply.reply);
                                                    await sock.sendMessage(remoteJid, { text: decryptedReply });
                                                } else if (auto_reply && auto_reply.media !== null) {
                                                    const decryptedReply = decrypt(auto_reply.reply);
                                                    const name = auto_reply.media;
                                                    const media = auto_reply.media;
                                                    const media_name = auto_reply.media_name;
                                                    const mediaType = name.split('.').pop().toLowerCase();
                                                    const filePath = path.join(__dirname, '../uploads', media);
                                                    let fileData;
                                    
                                                    if (['jpg', 'jpeg', 'png'].includes(mediaType)) {

                                                        fileData = { image: { url: filePath }, caption: decryptedReply };
                                                    } else if (mediaType === 'mp4') {
                                                        fileData = { video: { url: filePath }, caption: decryptedReply };
                                                    } else if (mediaType === 'pdf') {
                                                        fileData = { document: { url: filePath }, mimetype: 'application/pdf', fileName: media_name, caption: decryptedReply };
                                                    } else if (mediaType === 'xlsx') {
                                                        fileData = { document: { url: filePath }, mimetype: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', fileName: media_name, caption: decryptedReply };
                                                    } else if (mediaType === 'docx') { 
                                                        fileData = { document: { url: filePath }, mimetype: 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', fileName: media_name, caption: decryptedReply };
                                                    } else if (mediaType === 'csv') {
                                                        fileData = { document: { url: filePath }, mimetype: 'text/csv' , fileName: media_name };
                                                    } else {
                                                        fileData = { document: { url: filePath }, mimetype: 'application/octet-stream', caption: decryptedReply , fileName: media_name };
                                                    }
                                    
                                                    await sock.sendMessage(remoteJid, fileData);
                                                }
                                            }
                                            if ( company.allocation_status === 'inactive') {
                                                const user_group_data = await user_group.findAll({ where: { company_id: device.company_id } });
                                                
                                                if (user_group_data && user_group_data.length > 0) {
                                                    const user_ids = user_group_data.map(ug => ug.user_id);
                                                    const users_data = await users.findAll({ 
                                                        where: { 
                                                            id: user_ids,
                                                            role: { [Op.not]: 'Admin' } 
                                                        } 
                                                    });
                                                    
                                                    if (users_data && users_data.length > 0) {
                                                        for (const user of users_data) {
                                                            const user_id = user.id;
                                                            const user_phone_number = user.phone_number;
                                                            const encryptedSessionNumber = encrypt(token);
                                                            const encryptedCustomerNumber = encrypt(remoteJid);
                                                            const user_chat_accesses_data = await user_chat_accesses.findOne({ 
                                                                where: { 
                                                                    session_number: encryptedSessionNumber, 
                                                                    customer_number: encryptedCustomerNumber, 
                                                                    user_id 
                                                                } 
                                                            });
                                            
                                                            if (!user_chat_accesses_data) {
                                                                await user_chat_accesses.create({
                                                                    session_number: encryptedSessionNumber,
                                                                    customer_number: encryptedCustomerNumber,
                                                                    user_id,
                                                                    createdAt: new Date(),
                                                                    updatedAt: new Date()
                                                                });
                                                            }
                                                        }
                                                    }
                                                }
                                            }

                                            if (company.allocation_status === 'active') {
                                                try {
                                                    const auto_reply_details_data = await auto_reply_details.findOne({ where: { auto_reply_id: message_data.auto_reply_id } });
                                                    
                                                    if (auto_reply_details_data && auto_reply_details_data.user_id !== null) {
                                                        const auto_reply_user_id = auto_reply_details_data.user_id;
                                                        const encryptedSessionNumber = encrypt(token);
                                                        const encryptedCustomerNumber = encrypt(remoteJid);
                                            
                                                        const user_chat_accesses_data = await user_chat_accesses.findOne({ 
                                                            where: { 
                                                                session_number: encryptedSessionNumber, 
                                                                customer_number: encryptedCustomerNumber, 
                                                                user_id : auto_reply_user_id
                                                            } 
                                                        });

                                                        if (!user_chat_accesses_data) {
                                                            await user_chat_accesses.create({
                                                                session_number: encryptedSessionNumber,
                                                                customer_number: encryptedCustomerNumber,
                                                                user_id : auto_reply_user_id,
                                                                createdAt: new Date(),
                                                                updatedAt: new Date()
                                                            });
                                                        }
                                                    }
                                                }
                                                catch (error) {
                                                    console.error("Error handling inactive allocation status:", error);
                                                }
                                            }
                                        } 
                                        else{
                                            if (conversation_lower.includes(decryptedMessage)) {
                                                if ( company.allocation_status === 'inactive') {
                                                
                                                    const user_group_data = await user_group.findAll({ where: { company_id: device.company_id } });
                                                    
                                                    if (user_group_data && user_group_data.length > 0) {
                                                        const user_ids = user_group_data.map(ug => ug.user_id);
                                                        const users_data = await users.findAll({ 
                                                            where: { 
                                                                id: user_ids,
                                                                role: { [Op.not]: 'Admin' } 
                                                            } 
                                                        });
                                                        
                                                        if (users_data && users_data.length > 0) {
                                                            for (const user of users_data) {
                                                                const user_id = user.id;
                                                                const user_phone_number = user.phone_number;
                                                                const encryptedSessionNumber = encrypt(token);
                                                                const encryptedCustomerNumber = encrypt(remoteJid);
                                                                const user_chat_accesses_data = await user_chat_accesses.findOne({ 
                                                                    where: { 
                                                                        session_number: encryptedSessionNumber, 
                                                                        customer_number: encryptedCustomerNumber, 
                                                                        user_id 
                                                                    } 
                                                                });
                                                
                                                                if (!user_chat_accesses_data) {
                                                                    await user_chat_accesses.create({
                                                                        session_number: encryptedSessionNumber,
                                                                        customer_number: encryptedCustomerNumber,
                                                                        user_id,
                                                                        createdAt: new Date(),
                                                                        updatedAt: new Date()
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    }
                                                }

                                                if (company.allocation_status === 'active') {
                                                    try {
                                                        const auto_reply_details_data = await auto_reply_details.findOne({ where: { auto_reply_id: message_data.auto_reply_id } });
                                                        
                                                        if (auto_reply_details_data && auto_reply_details_data.user_id !== null) {
                                                            const auto_reply_user_id = auto_reply_details_data.user_id;
                                                            const encryptedSessionNumber = encrypt(token);
                                                            const encryptedCustomerNumber = encrypt(remoteJid);
                                                
                                                            const user_chat_accesses_data = await user_chat_accesses.findOne({ 
                                                                where: { 
                                                                    session_number: encryptedSessionNumber, 
                                                                    customer_number: encryptedCustomerNumber, 
                                                                    user_id : auto_reply_user_id
                                                                } 
                                                            });

                                                            if (!user_chat_accesses_data) {
                                                                await user_chat_accesses.create({
                                                                    session_number: encryptedSessionNumber,
                                                                    customer_number: encryptedCustomerNumber,
                                                                    user_id : auto_reply_user_id,
                                                                    createdAt: new Date(),
                                                                    updatedAt: new Date()
                                                                });
                                                            }
                                                        }
                                                    }
                                                    catch (error) {
                                                        console.error("Error handling inactive allocation status:", error);
                                                    }
                                                }

                                                
                                                const auto_reply = await auto_replies.findOne({ where: { id: message_data.auto_reply_id } });
                                                if (auto_reply && auto_reply.media === null) {
                                                    const decryptedReply = decrypt(auto_reply.reply);
                                                    await sock.sendMessage(remoteJid, { text: decryptedReply });
                                                } else if (auto_reply && auto_reply.media !== null) {
                                                    const decryptedReply = decrypt(auto_reply.reply);
                                                    const name = auto_reply.media;
                                                    const media = auto_reply.media;
                                                    const media_name = auto_reply.media_name;
                                                    const mediaType = name.split('.').pop().toLowerCase();
                                                    const filePath = path.join(__dirname, '../uploads', media);
                                                    let fileData;
                                    
                                                    if (['jpg', 'jpeg', 'png'].includes(mediaType)) {
                                                     
                                                        fileData = { image: { url: filePath }, caption: decryptedReply };
                                                    } else if (mediaType === 'mp4') {
                                                        fileData = { video: { url: filePath }, caption: decryptedReply };
                                                    } else if (mediaType === 'pdf') {
                                                        fileData = { document: { url: filePath }, mimetype: 'application/pdf', fileName: media_name, caption: decryptedReply };
                                                    } else if (mediaType === 'xlsx') {
                                                        fileData = { document: { url: filePath }, mimetype: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', fileName: media_name, caption: decryptedReply };
                                                    } else if (mediaType === 'docx') { 
                                                        fileData = { document: { url: filePath }, mimetype: 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', fileName: media_name, caption: decryptedReply };
                                                    } else if (mediaType === 'csv') {
                                                        fileData = { document: { url: filePath }, mimetype: 'text/csv' , fileName: media_name };
                                                    } else {
                                                        fileData = { document: { url: filePath }, mimetype: 'application/octet-stream', caption: decryptedReply , fileName: media_name };
                                                    }
                                    
                                                    await sock.sendMessage(remoteJid, fileData);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } catch (error) {
                        console.error("Error during processing:", error);
                    }
                }
            }
        }

        sock.ev.on("messages.upsert", async ({ messages }) => {
            const limit = pLimit(CONCURRENT_LIMIT);
            try {
                const tasks = messages.map(message => limit(() => chatProcess(message, token)));
                await Promise.all(tasks);
            } catch (error) {
                console.error('Error performing CRUD operation:', error);
            }
        });

        sock.ev.on('messaging-history.set', async (data) => {
            const oneMonthAgo = new Date();
            oneMonthAgo.setMonth(oneMonthAgo.getMonth() - 1);

            const limit = pLimit(CONCURRENT_LIMIT);
            try {
                const tasks = data.messages.filter(message => {


                    const messageTimestamp = new Date(message.messageTimestamp * 1000);
                    return messageTimestamp >= oneMonthAgo;
                }).map(message => limit(() => processMessage(message, token)));
                

                await Promise.all(tasks);
                

            } catch (error) {
                console.error('Error processing messages:', error);
            }
        });

        sock.ev.process(async (events) => {
            if (events['messages.update']) {
                const limit = pLimit(CONCURRENT_LIMIT);
                try {
                    const tasks = events['messages.update'].map(async update => {
                        await limit(() => processMessageUpdate(update, token));
                    });
                    await Promise.all(tasks);
                } catch (error) {
                    console.error('Error processing message updates:', error);
                }
            }
        });

        sock.ev.on("chats.update", async (chatInfoUpdate) => {
            const limit = pLimit(CONCURRENT_LIMIT);
            try {
                const tasks = chatInfoUpdate.map(chat => limit(() => processChatUpdates(chat, token)));
                await Promise.all(tasks);


                
            } catch (error) {
                console.error("Error processing chat update:", error);
            }
        });


        sock.ev.process(async (events) => {
            const device = await devices.findOne({ where: { session: session_encrypted } });
        
            if (device && device.sync_progress === 100) {
              
                return;
            }
        
            writeEncryptedFile(storePath, stores[token].toJSON(), secretKey);
        });


        stores[token].bind(sock.ev);


        sock.ev.on("creds.update", saveCreds);
    } catch (err) {
        console.log("Error in connectToWhatsApp:", err);
    }
}

async function processMessageUpdate(update, token) {
    try {
        const { key, update: updateInfo } = update;
        const { id: message_id } = key;
        let { status } = updateInfo;

        // Assume `chats` and `encrypt` are properly defined
        const encryptedToken = encrypt(token);
        const chat = await chats.findOne({ where: { message_id } });

        if (!status && chat) {
            status = 4;
        }

        await chats.update({ status }, { where: { message_id } });
    } catch (error) {
        console.error('Error processing message update:', error);
    }
}

async function processChatUpdates(chat, token) {
    try {
        const id = chat.id;
        const phoneNumber = id.split('@')[0];
        const incomingUnreadCount = chat.unreadCount;

        const senderPhoneNumber = token.split('@')[0];
        const encryptedSenderPhoneNumber = encrypt(token);
        const encryptedPhoneNumber = encrypt(id);

       
        if (incomingUnreadCount > 0) {
            const existingNotification = await sequelize.query(
                'SELECT * FROM notifications WHERE phone_number = :phone_number AND sender_phone_number = :sender_phone_number',
                {
                    replacements: { phone_number: encryptedPhoneNumber, sender_phone_number: encryptedSenderPhoneNumber },
                    type: QueryTypes.SELECT
                }
            );

            if (existingNotification.length > 0) {
                const updatedUnreadCount = existingNotification[0].unread_count + incomingUnreadCount;
                await sequelize.query(
                    'UPDATE notifications SET unread_count = :unread_count WHERE phone_number = :phone_number AND sender_phone_number = :sender_phone_number',
                    {
                        replacements: { unread_count: updatedUnreadCount, phone_number: encryptedPhoneNumber, sender_phone_number: encryptedSenderPhoneNumber },
                        type: QueryTypes.UPDATE
                    }
                );
            } else {
                await sequelize.query(
                    'INSERT INTO notifications (phone_number, unread_count, sender_phone_number, "createdAt", "updatedAt") VALUES (:phone_number, :unread_count, :sender_phone_number, :createdAt, :updatedAt)',
                    {
                        replacements: {
                            phone_number: encryptedPhoneNumber,
                            unread_count: incomingUnreadCount,
                            sender_phone_number: encryptedSenderPhoneNumber,
                            createdAt: new Date(),
                            updatedAt: new Date()
                        },
                        type: QueryTypes.INSERT
                    }
                );

                console.log("New notification created");
            }
        }
    } catch (error) {
        console.error("Error processing chat update:", error);
    }
}

async function processMessage(message, token) {
    try {
        const { key, messageTimestamp, pushName, broadcast, status } = message;
        let participant = message.participant || key.participant || null;
        let messageText = '';
        let contextInfo_stanzaId = null;
        let contextInfo_participant = null;
        let contextInfo_messageType = null;

        if (message.message) {
            if (message.message.extendedTextMessage && message.message.extendedTextMessage.text) {
                messageText = message.message.extendedTextMessage.text;
                contextInfo_stanzaId = message.message.extendedTextMessage.contextInfo?.stanzaId || null;
                contextInfo_participant = message.message.extendedTextMessage.contextInfo?.participant || null;
            } else if (message.message.conversation) {
                messageText = message.message.conversation;
            } else if (message.message.videoMessage) {
                messageText = `${message.message.videoMessage.caption}`;
            } else if (message.message.documentMessage) {
                messageText = `${message.message.documentMessage.caption}`;
            } else if (message.message.documentWithCaptionMessage) {
                const documentMessage = message.message.documentWithCaptionMessage.message.documentMessage;
                if (documentMessage && documentMessage.caption) {
                    messageText = `${documentMessage.caption}`;
                }
            } else if (message.message.imageMessage) {
                messageText = `${message.message.imageMessage.caption}`;
            }
        }

        if (message.message && message.message.extendedTextMessage) {
            if (message.message.extendedTextMessage.contextInfo?.quotedMessage?.videoMessage) {
                contextInfo_messageType = 'videoMessage';
            } else if (message.message.extendedTextMessage.contextInfo?.quotedMessage?.documentMessage) {
                contextInfo_messageType = 'documentMessage';
            } else if (message.message.extendedTextMessage.contextInfo?.quotedMessage?.imageMessage) {
                contextInfo_messageType = 'imageMessage';
            }
        }

        let messageType = null;
        let mediaType = null;
        let mediaFileLength = null;
        let mediaUrl = null;

        if (message.message && message.message.videoMessage) {
            messageType = 'videoMessage';
            mediaType = message.message.videoMessage.mimetype;
            mediaFileLength = message.message.videoMessage.fileLength;
            mediaUrl = message.message.videoMessage.url;
        } else if (message.message && message.message.documentMessage) {
            messageType = 'documentMessage';
            mediaType = message.message.documentMessage.mimetype;
            mediaFileLength = message.message.documentMessage.fileLength;
            mediaUrl = message.message.documentMessage.url;
        } else if (message.message && message.message.imageMessage) {
            messageType = 'imageMessage';
            mediaType = message.message.imageMessage.mimetype;
            mediaFileLength = message.message.imageMessage.fileLength;
            mediaUrl = message.message.imageMessage.url;
        } else if (message.message && message.message.audioMessage) {
            messageType = 'audioMessage';
            mediaType = message.message.audioMessage.mimetype;
            mediaFileLength = message.message.audioMessage.fileLength;
            mediaUrl = message.message.audioMessage.url;
        } else if (message.message && message.message.stickerMessage) {
            messageType = 'stickerMessage';
            mediaType = message.message.stickerMessage.mimetype;
            mediaFileLength = message.message.stickerMessage.fileLength;
            mediaUrl = message.message.stickerMessage.url;
        } else if (message.message && message.message.documentWithCaptionMessage) {
            messageType = 'documentWithCaptionMessage';
            mediaType = message.message.documentWithCaptionMessage.message.documentMessage.mimetype;
            mediaFileLength = message.message.documentWithCaptionMessage.message.documentMessage.fileLength;
            mediaUrl = message.message.documentWithCaptionMessage.message.documentMessage.url;
        }

        const encryptedRemoteJid = encrypt(key.remoteJid);
        const encryptedMessageText = encrypt(messageText);
        const encryptedToken = encrypt(token);
        // message.participant || key.participant || null; 
        // const encryptedParticipant = key.participant ? encrypt(key.participant) : null;
        const encryptedParticipant = participant ? encrypt(participant) : null;
        const pushNameEncrypted = encrypt(pushName) || null;

        const existingMessage = await chats.findOne({ where: { message_id: key.id , session: encryptedToken , fromMe: key.fromMe } });
   
        if (!existingMessage) {
            await chats.create({
                message_id: key.id,
                session: encryptedToken,
                remoteJid: encryptedRemoteJid,
                fromMe: key.fromMe,
                messageTimestamp,
                pushName: pushNameEncrypted,
                status,
                messageText: encryptedMessageText,
                isBroadcast: broadcast,
                messageType,
                mediaType,
                mediaFileLength,
                contextInfo_stanzaId,
                contextInfo_participant,
                contextInfo_messageType,
                participant: encryptedParticipant,
                type: 'ACTIVE',
                phone_number_id: null,
                import: true
            });
        }

        //download media 

        // const device = await devices.findOne({ where: { session: encryptedToken } });
        // //if message is image or document or video or audio
        // if (message.message && (message.message.imageMessage || message.message.documentMessage || message.message.videoMessage || message.message.audioMessage || message.message.stickerMessage || message.message.documentWithCaptionMessage)) {
        //     const mediaType = message.message.imageMessage ? 'image' : message.message.documentMessage ? 'document' : message.message.videoMessage ? 'video' : message.message.audioMessage ? 'audio' : message.message.stickerMessage ? 'sticker' : 'document';
        //     const mediaMessage = message.message.imageMessage || message.message.documentMessage || message.message.videoMessage || message.message.audioMessage || message.message.stickerMessage || message.message.documentWithCaptionMessage;
        //     const mediaUrl = mediaMessage.url;
        //     const mediaMimeType = mediaMessage.mimetype;
        //     const mediaFileLength = mediaMessage.fileLength;
        //     const mediaCaption = mediaMessage.caption || null;

        //     let mediaName;
        //     //if media is image then use key.id.jpg and if video then key.id.mp4 and if audio then key.id.mp3 and if document then use the key + filename + extension
        //     if (mediaType === 'image') {
        //         mediaName = `${key.id}.jpg`;
        //     } else if (mediaType === 'video') {
        //         mediaName = `${key.id}.mp4`;
        //     } else if (mediaType === 'audio') {
        //         mediaName = `${key.id}.mp3`;
        //     } else if (mediaType === 'sticker') {
        //         mediaName = `${key.id}.webp`;
        //     } else {
        //         mediaName = mediaMessage.fileName || null;
        //     }

        //     if (mediaName && mediaUrl !== null) {
        //         const existingMedia = await media_data_details.findOne({ where: { id_messsage: key.id } });
        //         if (!existingMedia) {
        //             await media_data_details.create({
        //                 media_data_name: mediaName,
        //                 media_data_size: mediaFileLength / 1024,
        //                 media_data_type: mediaType,
        //                 media_data_caption: mediaCaption,
        //                 media_data_mime_type: mediaMimeType,
        //                 date: new Date(),
        //                 session: encryptedToken,
        //                 company_id: device.company_id,
        //                 number_jid: encryptedRemoteJid,
        //                 origin_media_url: mediaUrl,
        //                 origin_media_name: mediaName,
        //                 type: 'ACTIVE',
        //                 id_messsage: key.id
        //             });
        //         } 
        //     }
        // }
    } catch (error) {
        console.error('Error processing message:', error);
    }
}

async function chatProcess(message, token) {
    try {

        const { key, messageTimestamp, pushName, broadcast, status, participant } = message;
        let messageText = '';
        let contextInfo_stanzaId = null;
        let contextInfo_participant = null;
        let contextInfo_messageType = null;

        if (message.message) {
            if (message.message.extendedTextMessage && message.message.extendedTextMessage.text) {
                messageText = message.message.extendedTextMessage.text;
                contextInfo_stanzaId = message.message.extendedTextMessage.contextInfo?.stanzaId || null;
                contextInfo_participant = message.message.extendedTextMessage.contextInfo?.participant || null;
            } else if (message.message.conversation) {
                messageText = message.message.conversation;
            } else if (message.message.videoMessage) {
                messageText = `${message.message.videoMessage.caption}`;
            } else if (message.message.documentMessage) {
                messageText = `${message.message.documentMessage.caption}`;
            } else if (message.message.documentWithCaptionMessage) {
                const documentMessage = message.message.documentWithCaptionMessage.message.documentMessage;
                if (documentMessage && documentMessage.caption) {
                    messageText = `${documentMessage.caption}`;
                }
            } else if (message.message.imageMessage) {
                messageText = `${message.message.imageMessage.caption}`;
            }
        }

        if (message.message && message.message.extendedTextMessage) {
            if (message.message.extendedTextMessage.contextInfo?.quotedMessage?.videoMessage) {
                contextInfo_messageType = 'videoMessage';
            } else if (message.message.extendedTextMessage.contextInfo?.quotedMessage?.documentMessage) {
                contextInfo_messageType = 'documentMessage';
            } else if (message.message.extendedTextMessage.contextInfo?.quotedMessage?.imageMessage) {
                contextInfo_messageType = 'imageMessage';
            }
        }

        let messageType = null;
        let mediaType = null;
        let mediaFileLength = null;
        let mediaUrl = null;

        if (message.message && message.message.videoMessage) {
            messageType = 'videoMessage';
            mediaType = message.message.videoMessage.mimetype;
            mediaFileLength = message.message.videoMessage.fileLength;
            mediaUrl = message.message.videoMessage.url;
        } else if (message.message && message.message.documentMessage) {
            messageType = 'documentMessage';
            mediaType = message.message.documentMessage.mimetype;
            mediaFileLength = message.message.documentMessage.fileLength;
            mediaUrl = message.message.documentMessage.url;
        } else if (message.message && message.message.imageMessage) {
            messageType = 'imageMessage';
            mediaType = message.message.imageMessage.mimetype;
            mediaFileLength = message.message.imageMessage.fileLength;
            mediaUrl = message.message.imageMessage.url;
        } else if (message.message && message.message.audioMessage) {
            messageType = 'audioMessage';
            mediaType = message.message.audioMessage.mimetype;
            mediaFileLength = message.message.audioMessage.fileLength;
            mediaUrl = message.message.audioMessage.url;
        } else if (message.message && message.message.stickerMessage) {
            messageType = 'stickerMessage';
            mediaType = message.message.stickerMessage.mimetype;
            mediaFileLength = message.message.stickerMessage.fileLength;
            mediaUrl = message.message.stickerMessage.url;
        } else if (message.message && message.message.documentWithCaptionMessage) {
            messageType = 'documentWithCaptionMessage';
            mediaType = message.message.documentWithCaptionMessage.message.documentMessage.mimetype;
            mediaFileLength = message.message.documentWithCaptionMessage.message.documentMessage.fileLength;
            mediaUrl = message.message.documentWithCaptionMessage.message.documentMessage.url;
        }

        const encryptedRemoteJid = encrypt(key.remoteJid);
        const encryptedMessageText = encrypt(messageText);
        const encryptedToken = encrypt(token);
        const encryptedParticipant = key.participant ? encrypt(key.participant) : null;
        const pushNameEncrypted = encrypt(pushName) || null; 

        const existingMessage = await chats.findOne({ where: { message_id: key.id , session: encryptedToken } });
        if (message.message?.protocolMessage?.type === 0) {
            const notifyMessage = await chats.findOne({ where: { message_id: message.message.protocolMessage.key.id } });
            if (notifyMessage) {
                await chats.update({ type: 'REVOKE' }, { where: { message_id: message.message.protocolMessage.key.id } });
            }
        } else if (!existingMessage) {
            
            await chats.create({
                message_id: key.id,
                session: encryptedToken,
                remoteJid: encryptedRemoteJid,
                fromMe: key.fromMe,
                messageTimestamp,
                pushName : pushNameEncrypted,
                status,
                messageText: encryptedMessageText,
                isBroadcast: broadcast,
                messageType,
                mediaType,
                mediaFileLength,
                contextInfo_stanzaId,
                contextInfo_participant,
                contextInfo_messageType,
                participant: encryptedParticipant,
                type: 'ACTIVE',
                phone_number_id: null,
                import: false
            });
        } else {

            await chats.update({
                session: encryptedToken,
                remoteJid: encryptedRemoteJid,
                fromMe: key.fromMe,
                messageTimestamp,
                pushName : pushNameEncrypted,
                status,
                messageText: encryptedMessageText,
                isBroadcast: broadcast,
                messageType,
                mediaType,
                mediaFileLength,
                contextInfo_stanzaId,
                contextInfo_participant,
                contextInfo_messageType,
                participant: encryptedParticipant,
                type: 'ACTIVE',
                phone_number_id: null,
                import: false
            }, {
                where: { message_id: key.id }
            });
        }
    } catch (error) {
        console.error('Error processing message:', error);
    }
}         
                                 

async function reconnect(token) {
    await delay(5000); 
    await connectToWhatsApp(token);
}

function delay(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}

async function sendMessage(req, res) {
    const token = req.body.session;
    const user_id = req.body.user_id;
    const session = token + '@s.whatsapp.net';
    const sock = sockets[session];
    if (!sock) {
        return res.status(500).json({
            status: false,
            response: `Session ${session} not found or not connected.`,
        });
    }

    const pesankirim = req.body.message;
    let number = req.body.number;

    const fileDikirim = req.files;

    if (number.includes('62')) {
        number = number + '@s.whatsapp.net';
    } else {
        number = number + '@g.us';
    }

    try {
        if (!fileDikirim) {
            if (!number) {
                return res.status(500).json({
                    status: false,
                    response: 'Nomor WA belum disertakan!'
                });
            }

            const numberWA = number;

            if (numberWA.includes('@g.us')) {
                const messageResponse = await sock.sendMessage(numberWA, { text: pesankirim });
                return res.status(200).json({
                    status: true,
                    response: 'Pesan terkirim!',
                    messageId: messageResponse.key.id,
                });
            }

            // const exists = await sock.onWhatsApp(numberWA);

            // if (!exists || !sock.isConnected) {
            //     return res.status(500).json({
            //         status: false,
            //         response: 'WhatsApp belum terhubung atau nomor tidak ditemukan.'
            //     });
            // }

            const messageResponse = await sock.sendMessage(numberWA, { text: pesankirim });
            
            await chat_sender_details.create({
                session: encrypt(session),
                numbers: encrypt(numberWA),
                message_id: messageResponse.key.id,
                user_id : user_id,
            });

            
            return res.status(200).json({
                status: true,
                response: 'Pesan terkirim!',
                messageId: messageResponse.key.id,
            });

        } else {
            const encryptedSession = encrypt(session);

            const device = await devices.findOne({ where: { session: encryptedSession } });
            if (!device) {
                return res.status(500).json({
                    status: false,
                    response: 'Device not found'
                });
            }
            const company = await companies.findOne({ where: { id: device.company_id } });
            if (!company) {
                return res.status(500).json({
                    status: false,
                    response: 'Company not found'
                });
            }
            const packageGroup = await package_groups.findAll({ where: { company_id: device.company_id }, order: [['createdAt', 'DESC']] });

            if (!packageGroup) {
                return res.status(500).json({
                    status: false,
                    response: 'Package group not found'
                });
            }
            const packageFeature = await sequelize.query(`SELECT * FROM package_features WHERE package_id = ${packageGroup[0].package_id} AND feature_id = 13`, { type: Sequelize.QueryTypes.SELECT });
            if (packageFeature.length === 0) {
                return res.status(500).json({
                    status: false,
                    response: 'Package feature not found'
                });
            }

            const mediaDataDetails = await media_data_details.findAll({ where: { company_id: device.company_id } });
            let totalMediaSize = 0;
            for (const mediaDataDetail of mediaDataDetails) {
                totalMediaSize += mediaDataDetail.media_data_size;
            }

            let amountLimit = packageFeature[0].amount_limit * 1024 * 1024;

            if (totalMediaSize >= amountLimit) {
                return res.status(500).json({
                    status: false,
                    response: 'Kamu telah mencapai batas penggunaan file'
                });
            }

            if (!number) {
                return res.status(500).json({
                    status: false,
                    response: 'Nomor WA belum disertakan!'
                });
            }

            const numberWA = number;

            const filesimpan = req.files.file_dikirim;
            const file_ubah_nama = new Date().getTime() + '_' + filesimpan.name;
            const filePath = './uploads/' + file_ubah_nama;

            await filesimpan.mv(filePath);

            let fileData;
            if (filesimpan.mimetype.startsWith('image')) {
                fileData = { image: { url: filePath }, caption: pesankirim };
            } else if (filesimpan.mimetype.startsWith('audio')) {
                fileData = { audio: { url: filePath }, mimetype: 'audio/mp4', caption: pesankirim };
            } else {
                fileData = { document: { url: filePath }, mimetype: filesimpan.mimetype, fileName: filesimpan.name, caption: pesankirim };
            }

            const messageResponse = await sock.sendMessage(numberWA, fileData);
            
                 
            await chat_sender_details.create({
                session: encryptedSession,
                numbers: encrypt(numberWA),
                message_id: messageResponse.key.id,
                user_id : user_id,
            });
    
            fs.unlink(filePath, (err) => {
                if (err) {
                    console.error(err);
                }
            });

            return res.status(200).json({
                status: true,
                response: 'Pesan dengan file terkirim!',
                messageId: messageResponse.key.id,
            });

        }
    } catch (err) {
        console.error(err);
        return res.status(500).json({
            status: false,
            response: 'Internal server error'
        });
    }
}
async function downloadProfilePicture(req, res) {
    const token = req.query.session;
    const session = token + '@s.whatsapp.net';
    const id = req.query.id + '@s.whatsapp.net';
    const sock = sockets[session];
    if (!sock) {
        return res.status(500).json({
            status: false,
            response: `Session ${session} not found or not connected.`,
        });
    }

    try {
        const profilePicture = await sock.profilePictureUrl(id, 'image');
        if (profilePicture) {
            const protocol = profilePicture.startsWith('https') ? https : http;

            protocol.get(profilePicture, async (response) => {
                if (response.statusCode !== 200) {
                    
                    return res.status(500).json({ status: false, response: 'Failed to fetch profile picture' });
                }

                const buffer = [];
                response.on('data', (chunk) => {
                    buffer.push(chunk);
                });

                response.on('end', () => {
                    const data = Buffer.concat(buffer);
                    fs.writeFileSync(path.join(__dirname, '../media', `${id}_profile_picture.jpg`), data);
             
                    return res.status(200).json({ status: true, response: 'Profile picture downloaded' });
                });
            }).on('error', (error) => {
                
                return res.status(500).json({ status: false, response: 'Error downloading profile picture' });
            });

        } else {
            return res.status(404).json({ status: false, response: 'Profile picture not found' });
        }

    } catch (error) {
        return res.status(404).json({ status: false, response: 'Profile picture not found' });
    }
}

// async function readChat(socket, token, number, total) {
//     try {
//         if (!token) {
//             return socket.emit('chat_history_response', { error: 'Token not provided' });
//         }

//         if (!number) {
//             return socket.emit('chat_history_response', { error: 'Number not provided' });
//         }

//         const fullToken = `${token}@s.whatsapp.net`;
//         const fullNumber = number.includes('62') ? `${number}@s.whatsapp.net` : `${number}@g.us`;

//         const encryptedNumber = encrypt(fullNumber);
//         const encryptedToken = encrypt(fullToken);

//         const chatResult = await sequelize.query(`
//             SELECT * FROM "chats"
//             WHERE "session" = ? AND "remoteJid" = ?
//             ORDER BY "messageTimestamp" DESC`, 
//             { replacements: [encryptedToken, encryptedNumber], type: sequelize.QueryTypes.SELECT }
//         );

//         if (chatResult.length === 0) {
//             return socket.emit('chat_history_response', { error: 'No messages found' });
//         }

//         const data = [];
//         const mediaMessageTypes = ['documentMessage', 'documentWithCaptionMessage', 'imageMessage', 'videoMessage', 'audioMessage', 'stickerMessage'];
//         let results = total || 30;
//         const maxMessages = results; 

//         for (const message of chatResult) {
//             if (data.length >= maxMessages) {
//                 break;  
//             }

//             let participant = null;
//             if(message.participant !== null){
            
//                 const decryptedRemoteJid = decrypt(message.participant);
                
//                 const phoneNumber = decryptedRemoteJid.split('@')[0];
//                 const encryptedPhoneNumber = encrypt(phoneNumber);

//                 const customerQuery = `
//                     SELECT name FROM customers
//                     WHERE phone = :phone AND company_id = :company
//                 `;

//                 const [customerResult] = await sequelize.query(customerQuery, {
//                     replacements: { phone: encryptedPhoneNumber , company: 2 },
//                     type: sequelize.QueryTypes.SELECT
//                 });

//                 participant = customerResult ? decrypt(customerResult.name) : decryptedRemoteJid;
//             }
//             else{
//                 participant = null;
//             }

//             const messageData = {
//                 remoteJid: decrypt(message.remoteJid),
//                 messageTimestamp: message.messageTimestamp,
//                 messageText: decrypt(message.messageText),
//                 id: message.id,
//                 fromMe: message.fromMe,
//                 pushName: participant,
//                 status: message.status,
//                 messageType: message.messageType,
//                 mediaType: message.mediaType,
//                 mediaFileLength: message.mediaFileLength,
//                 createdAt: message.createdAt,
//                 updatedAt: message.updatedAt,
//                 message_id: message.message_id,
//                 contextInfo_stanzaId: message.contextInfo_stanzaId,
//                 contextInfo_participant: message.contextInfo_participant,
//                 contextInfo_messageType: message.contextInfo_messageType,
//                 type: message.type,
//                 participant: message.participant,
//                 unread_count: message.unread_count,
//                 media_data_name: message.media_data_name,
//                 phone_number_id: message.phone_number_id
//             };

//             if (mediaMessageTypes.includes(message.messageType)) {
//                 const mediaDataResult = await sequelize.query(`
//                     SELECT * FROM "media_data_details"
//                     WHERE "id_messsage" = ?`, 
//                     { replacements: [message.message_id], type: sequelize.QueryTypes.SELECT }
//                 );

//                 if (mediaDataResult.length > 0) {
//                     const mediaData = mediaDataResult[0];
//                     messageData.media_data_name = mediaData.media_data_name;
//                     messageData.document_path = `/media/${mediaData.media_data_name}`;
//                 }
//             }

//             data.push(messageData);
//         }

//         for (const message of data) {
//             const chatSenderDetailsResult = await sequelize.query(`
//                 SELECT * FROM "chat_sender_details"
//                 WHERE "message_id" = ?`, 
//                 { replacements: [message.message_id], type: sequelize.QueryTypes.SELECT }
//             );

//             if (chatSenderDetailsResult.length > 0) {
//                 const chatSenderDetails = chatSenderDetailsResult[0];
//                 const user = await users.findOne({ where: { id: chatSenderDetails.user_id } });
//                 if(user){
//                     message.user_id = user.id;
//                     message.user_name = decrypt(user.name);
//                 }
//                 else{
//                     message.user_id = null;
//                     message.user_name = null;
//                 }
//             }
//         }

//         data.sort((a, b) => a.messageTimestamp - b.messageTimestamp);
//         socket.emit('chat_history_response', { messages: data.slice(0, maxMessages) });

//     } catch (error) {
//         console.error(error);
//         socket.emit('chat_history_response', { error: 'Error reading chat history' });
//     }
// }


async function readChat(socket, token, number, total, company_id) {
    try {
        if (!token) {
            return socket.emit('chat_history_response', { error: 'Token not provided' });
        }

        if (!number) {
            return socket.emit('chat_history_response', { error: 'Number not provided' });
        }

        const fullToken = `${token}@s.whatsapp.net`;
        const fullNumber = number.includes('62') ? `${number}@s.whatsapp.net` : `${number}@g.us`;

        const encryptedNumber = encrypt(fullNumber);
        const encryptedToken = encrypt(fullToken);

        const chatResult = await sequelize.query(`
            SELECT * FROM "chats"
            WHERE "session" = ? AND "remoteJid" = ?
            ORDER BY "messageTimestamp" DESC`, 
            { replacements: [encryptedToken, encryptedNumber], type: sequelize.QueryTypes.SELECT }
        );

        if (chatResult.length === 0) {
            return socket.emit('chat_history_response', { error: 'No messages found' });
        }

        const data = [];
        const mediaMessageTypes = ['documentMessage', 'documentWithCaptionMessage', 'imageMessage', 'videoMessage', 'audioMessage', 'stickerMessage', 'documentWithCaptionMessage'];
        let results = total || 30;
        const maxMessages = results + 1; // Adding 1 to determine if there are more messages for pagination

        const limit = pLimit(CONCURRENT_LIMIT);

        const tasks = chatResult.slice(0, maxMessages).map((message) => limit(async () => {
            let participant = null;
            if (message.participant !== null) {
                const decryptedRemoteJid = decrypt(message.participant);
                const phoneNumber = decryptedRemoteJid.split('@')[0];
                const encryptedPhoneNumber = encrypt(phoneNumber);

                const customerQuery = `
                    SELECT name FROM customers
                    WHERE phone = :phone AND company_id = :company
                `;

                const [customerResult] = await sequelize.query(customerQuery, {
                    replacements: { phone: encryptedPhoneNumber, company: company_id },
                    type: sequelize.QueryTypes.SELECT
                });

                participant = customerResult ? decrypt(customerResult.name) : decryptedRemoteJid;
            }

            const messageData = {
                remoteJid: decrypt(message.remoteJid),
                messageTimestamp: message.messageTimestamp,
                messageText: decrypt(message.messageText),
                id: message.id,
                fromMe: message.fromMe,
                pushName: participant,
                status: message.status,
                messageType: message.messageType,
                mediaType: message.mediaType,
                mediaFileLength: message.mediaFileLength,
                createdAt: message.createdAt,
                updatedAt: message.updatedAt,
                message_id: message.message_id,
                contextInfo_stanzaId: message.contextInfo_stanzaId,
                contextInfo_participant: message.contextInfo_participant,
                contextInfo_messageType: message.contextInfo_messageType,
                type: message.type,
                participant: message.participant,
                unread_count: message.unread_count,
                media_data_name: message.media_data_name,
                phone_number_id: message.phone_number_id
            };

            if (mediaMessageTypes.includes(message.messageType)) {
                const mediaDataResult = await sequelize.query(`
                    SELECT * FROM "media_data_details"
                    WHERE "id_messsage" = ?`, 
                    { replacements: [message.message_id], type: sequelize.QueryTypes.SELECT }
                );

                if (mediaDataResult.length > 0) {
                    const mediaData = mediaDataResult[0];
                    messageData.media_data_name = mediaData.media_data_name;
                    messageData.document_path = `/media/${mediaData.media_data_name}`;
                }
            }

            const chatSenderDetailsResult = await sequelize.query(`
                SELECT * FROM "chat_sender_details"
                WHERE "message_id" = ?`, 
                { replacements: [message.message_id], type: sequelize.QueryTypes.SELECT }
            );

            if (chatSenderDetailsResult.length > 0) {
                const chatSenderDetails = chatSenderDetailsResult[0];
                const user = await users.findOne({ where: { id: chatSenderDetails.user_id } });
                if (user) {
                    messageData.user_id = user.id;
                    messageData.user_name = decrypt(user.name);
                } else {
                    messageData.user_id = null;
                    messageData.user_name = null;
                }
            }

            return messageData;
        }));

        const resultData = await Promise.all(tasks);
        const paginatedData = resultData.slice(0, results);
        const hasMoreMessages = resultData.length > results;

        paginatedData.sort((a, b) => a.messageTimestamp - b.messageTimestamp);

        socket.emit('chat_history_response', { 
            messages: paginatedData,
            pagination: hasMoreMessages 
        });

    } catch (error) {
        console.error(error);
        socket.emit('chat_history_response', { error: 'Error reading chat history' });
    }
}


// async function allChatHistory(socket, session, user_id, company_id, total, filters) {
//     const limit = total || 1;
    
//     let order = 'DESC';
//     if (filters === 'latest') {
//         order = 'ASC';
//     } else {
//         order = 'DESC';
//     }

//     try {
//         const userRoleQuery = `
//             SELECT role
//             FROM users
//             WHERE id = :user_id
//         `;
//         const [userRoleResult] = await sequelize.query(userRoleQuery, {
//             replacements: { user_id: user_id },
//             type: sequelize.QueryTypes.SELECT
//         });

//         if (!userRoleResult || !userRoleResult.role) {
//             return socket.emit('all_chat_history', { error: 'User not found' });
//         }

//         const userRole = userRoleResult.role;

//         const token = session + '@s.whatsapp.net';
//         const encryptedToken = encrypt(token);

//         const chatQuery = `
//             SELECT *
//             FROM (
//                 SELECT DISTINCT ON ("remoteJid") *
//                 FROM chats
//                 WHERE session = :session
//                 ORDER BY "remoteJid", "messageTimestamp" DESC
//             ) subquery
//             ORDER BY "messageTimestamp" ${order}
//         `;

//         let chatList = await sequelize.query(chatQuery, {
//             replacements: { session: encryptedToken },
//             type: sequelize.QueryTypes.SELECT
//         });

//         if (chatList.length === 0) {
//             return socket.emit('all_chat_history', { error: 'No messages found' });
//         }

//         if (userRole === 'User') {
//             const queryChatAccess = `
//                 SELECT customer_number, session_number FROM user_chat_accesses
//                 WHERE user_id = :user_id
//             `;

//             const chatAccessResult = await sequelize.query(queryChatAccess, {
//                 replacements: { user_id: user_id, session_number: encryptedToken },
//                 type: sequelize.QueryTypes.SELECT
//             });

//             const chatAccessNumbers = chatAccessResult.map(access => access.customer_number);
//             const sessionNumbers = chatAccessResult.map(access => access.session_number);

//             chatList = chatList.filter(chat => 
//                 chatAccessNumbers.includes(chat.remoteJid) && 
//                 sessionNumbers.includes(chat.session)
//             );
//         }

//         const decryptedChatList = [];

//         for (const chat of chatList) {
//             if (chat.remoteJid !== encryptedToken) {
//                 const remoteJid = chat.remoteJid;

//                 const decryptedRemoteJid = decrypt(remoteJid);
//                 const decryptedMessageText = decrypt(chat.messageText);
//                 const customer_phone = encrypt(decryptedRemoteJid.split('@')[0]);

//                 if ((!decryptedMessageText || decryptedMessageText.trim() === '') && (!chat.messageType || chat.messageType.trim() === '')) {
//                     continue;
//                 }

//                 if (filters === 'grub' && !decryptedRemoteJid.includes('@g.us')) {
//                     continue;
//                 }

//                 if (decryptedRemoteJid.includes('@broadcast')) {
//                     continue;
//                 }

//                 const notificationQuery = `
//                     SELECT unread_count
//                     FROM notifications
//                     WHERE sender_phone_number = :tokenPhoneNumber 
//                     AND phone_number = :decryptedRemoteJidPhone
//                 `;
//                 const [notificationResult] = await sequelize.query(notificationQuery, {
//                     replacements: { tokenPhoneNumber: encryptedToken, decryptedRemoteJidPhone: remoteJid },
//                     type: sequelize.QueryTypes.SELECT
//                 });

//                 if (filters === 'unread_count' && (!notificationResult || notificationResult.unread_count === 0)) {
//                     continue;
//                 }

//                 const customerQuery = `
//                     SELECT name FROM customers
//                     WHERE phone = :decryptedRemoteJidPhone
//                         AND company_id = :company
//                 `;

//                 const [customerResult] = await sequelize.query(customerQuery, {
//                     replacements: { decryptedRemoteJidPhone: customer_phone, company: company_id },
//                     type: sequelize.QueryTypes.SELECT
//                 });
                

//                 const pushName = customerResult ? decrypt(customerResult.name) : decryptedRemoteJid;
//                 const profilePicture = getProfilePicture(decryptedRemoteJid);

//                 decryptedChatList.push({
//                     ...chat,
//                     remoteJid: decryptedRemoteJid,
//                     messageText: decryptedMessageText,
//                     pushName: pushName,
//                     profilePicture: profilePicture,
//                     unread_count: notificationResult ? notificationResult.unread_count : 0
//                 });

//                 if (decryptedChatList.length >= limit) {
//                     break;
//                 }
//             }
//         }
//         if (filters === 'unread_count') {
//             decryptedChatList.sort((a, b) => b.unread_count - a.unread_count);
//         }

//         socket.emit('all_chat_history', { latestMessages: decryptedChatList });
//     } catch (error) {
//         socket.emit('all_chat_history', { error: 'Error reading chat history', error: error });
//     } finally {
//     }
// }

async function allChatHistory(socket, session, user_id, company_id, total, filters) {
    const limit = (total || 1) + 1; 
    const plimit = pLimit(CONCURRENT_LIMIT);

    let order = 'DESC';
    if (filters === 'latest') {
        order = 'ASC';
    } else {
        order = 'DESC';
    }

    try {
        const userRoleQuery = `
            SELECT role
            FROM users
            WHERE id = :user_id
        `;
        const [userRoleResult] = await sequelize.query(userRoleQuery, {
            replacements: { user_id: user_id },
            type: sequelize.QueryTypes.SELECT
        });

        if (!userRoleResult || !userRoleResult.role) {
            return socket.emit('all_chat_history', { error: 'User not found' });
        }

        const userRole = userRoleResult.role;

        const token = session + '@s.whatsapp.net';
        const encryptedToken = encrypt(token);

        const chatQuery = `
            SELECT *
            FROM (
                SELECT DISTINCT ON ("remoteJid") *
                FROM chats
                WHERE session = :session
                ORDER BY "remoteJid", "messageTimestamp" DESC
            ) subquery
            ORDER BY "messageTimestamp" ${order}
            LIMIT :limit
        `;

        let chatList = await sequelize.query(chatQuery, {
            replacements: { session: encryptedToken, limit: limit },
            type: sequelize.QueryTypes.SELECT
        });

        if (chatList.length === 0) {
            return socket.emit('all_chat_history', { error: 'No messages found' });
        }

        if (userRole === 'User') {
            const queryChatAccess = `
                SELECT customer_number, session_number FROM user_chat_accesses
                WHERE user_id = :user_id
            `;

            const chatAccessResult = await sequelize.query(queryChatAccess, {
                replacements: { user_id: user_id, session_number: encryptedToken },
                type: sequelize.QueryTypes.SELECT
            });

            const chatAccessNumbers = chatAccessResult.map(access => access.customer_number);
            const sessionNumbers = chatAccessResult.map(access => access.session_number);

            chatList = chatList.filter(chat => 
                chatAccessNumbers.includes(chat.remoteJid) && 
                sessionNumbers.includes(chat.session)
            );
        }

        const decryptedChatList = [];

        const tasks = chatList.map(chat => plimit(async () => {
            if (chat.remoteJid !== encryptedToken) {
                const remoteJid = chat.remoteJid;

                const decryptedRemoteJid = decrypt(remoteJid);
                const decryptedMessageText = decrypt(chat.messageText);
                const customer_phone = encrypt(decryptedRemoteJid.split('@')[0]);

                if ((!decryptedMessageText || decryptedMessageText.trim() === '') && (!chat.messageType || chat.messageType.trim() === '')) {
                    return null;
                }

                if (filters === 'grub' && !decryptedRemoteJid.includes('@g.us')) {
                    return null;
                }

                if (decryptedRemoteJid.includes('@broadcast')) {
                    return null;
                }

                const notificationQuery = `
                    SELECT unread_count
                    FROM notifications
                    WHERE sender_phone_number = :tokenPhoneNumber 
                    AND phone_number = :decryptedRemoteJidPhone
                `;
                const [notificationResult] = await sequelize.query(notificationQuery, {
                    replacements: { tokenPhoneNumber: encryptedToken, decryptedRemoteJidPhone: remoteJid },
                    type: sequelize.QueryTypes.SELECT
                });

                if (filters === 'unread_count' && (!notificationResult || notificationResult.unread_count === 0)) {
                    return null;
                }

                const customerQuery = `
                    SELECT name FROM customers
                    WHERE phone = :decryptedRemoteJidPhone
                        AND company_id = :company
                `;

                const [customerResult] = await sequelize.query(customerQuery, {
                    replacements: { decryptedRemoteJidPhone: customer_phone, company: company_id },
                    type: sequelize.QueryTypes.SELECT
                });

                const pushName = customerResult ? decrypt(customerResult.name) : decryptedRemoteJid;
                const profilePicture = getProfilePicture(decryptedRemoteJid);

                return {
                    ...chat,
                    remoteJid: decryptedRemoteJid,
                    messageText: decryptedMessageText,
                    pushName: pushName,
                    profilePicture: profilePicture,
                    unread_count: notificationResult ? notificationResult.unread_count : 0
                };
            }
            return null;
        }));

        const results = await Promise.all(tasks);
        const filteredResults = results.filter(result => result !== null);

        if (filters === 'unread_count') {
            filteredResults.sort((a, b) => b.unread_count - a.unread_count);
        }

        const hasMore = filteredResults.length > total;
        const latestMessages = hasMore ? filteredResults.slice(0, total) : filteredResults;

        socket.emit('all_chat_history', { latestMessages: latestMessages, pagination: hasMore });
    } catch (error) {
        socket.emit('all_chat_history', { error: 'Error reading chat history', error: error });
    }
}


async function numberOnChatHistory(req, res) {
    try {
        const searchTerm = req.query.search;
        const company_id = req.query.company_id;
        let limit = parseInt(req.query.limit, 10);

        if (isNaN(limit) || limit <= 0) {
            limit = 30; 
        }

        const query = `
            SELECT * FROM customers 
            WHERE company_id = :company_id;
        `;

        const customerList = await sequelize.query(query, {
            replacements: { company_id: company_id },
            type: sequelize.QueryTypes.SELECT
        });

        if (customerList.length === 0) {
            return res.status(404).json({ error: 'Customer not found' });
        }

        const results = [];
        let count = 0;
        
        for (const customer of customerList) {
            if (count >= limit) break;
            
            const decryptedPhone = decrypt(customer.phone);
            if (!searchTerm || decryptedPhone.includes(searchTerm)) {
                let phone_number;
                if (customer.type === 'customer') {
                    phone_number = decryptedPhone + '@s.whatsapp.net';
                } else {
                    phone_number = decryptedPhone + '@g.us';
                }
                    
                const profilePicture = getProfilePicture(phone_number);
                results.push({
                    number: decryptedPhone,
                    profilePicture: profilePicture,
                    pushname: decrypt(customer.name)
                });
                
                count++;
            }
        }
        return res.status(200).json(results);
    } catch (error) {
        console.error('Error:', error);
        return res.status(500).json({ error: 'Internal Server Error' });
    }
}

async function searchDataMessage(req, res) {
    try {
        const searchTerm = req.query.search.toLowerCase();
        const company_id = req.query.company_id;
        const session = req.query.session;

        let results = { latestMessages: [] }; 

        const customerQuery = `
            SELECT phone, name FROM customers 
            WHERE company_id = :company_id;
        `;

        const contactList = await sequelize.query(customerQuery, {
            replacements: { company_id: company_id },
            type: sequelize.QueryTypes.SELECT
        });

        const decryptedContacts = contactList.map(contact => {
            return {
                phone: decrypt(contact.phone),
                name: contact.name ? decrypt(contact.name) : null
            };

        });


        const filteredContacts = decryptedContacts.filter(contact => {
            return contact.phone.toLowerCase().includes(searchTerm) || (contact.name && contact.name.toLowerCase().includes(searchTerm));
        });


        for (const contact of filteredContacts) {
            const decryptedPhone = encrypt(contact.phone + '@s.whatsapp.net');
            const profilePicture = getProfilePicture(decryptedPhone);
            const encryptedSession = encrypt(session);

            const pushName = contact.name ? contact.name : contact.phone;

            const number = decrypt(decryptedPhone);

            const chatQuery = `
                SELECT * FROM "chats"
                WHERE "session" = :session AND "remoteJid" = :phone_number
                ORDER BY "createdAt" DESC
                LIMIT 1;
            `;
            
            const chatList = await sequelize.query(chatQuery, {
                replacements: { session: encryptedSession, phone_number: decryptedPhone },
                type: sequelize.QueryTypes.SELECT
            });

            if (chatList.length > 0) {
                const chat = chatList[0];
                const messageText = decrypt(chat.messageText);
         
                const sessionSplit = encrypt(session);
                const notificationsResult = await sequelize.query(`
                    SELECT * FROM notifications
                    WHERE sender_phone_number = :sessionSplit AND phone_number = :phone_number`,
                    { replacements: { sessionSplit: sessionSplit, phone_number: decryptedPhone }, type: sequelize.QueryTypes.SELECT }
                );

                let grouping = "contact";
                
                results.latestMessages.push({
                    ...chat,
                    remoteJid: decrypt(decryptedPhone),
                    remoteJid: number,
                    profilePicture: profilePicture,
                    pushName: pushName,
                    messageText: messageText,
                    grouping: grouping,
                    unread_count: notificationsResult.length > 0 ? notificationsResult[0].unread_count : 0
                });
            }
            else {
                results.latestMessages.push({
                    remoteJid: number,
                    profilePicture: profilePicture,
                    pushName: contact.name,
                    messageText: null,
                    unread_count: 0,
                    messageTimestamp: null,
                    id: null,
                    fromMe: null,
                    status: null,
                    messageType: null,
                    mediaType: null,
                    mediaFileLength: null,
                    type: null,
                    latestMessage: null,
                    message_id: null,
                    message_id: null,
                    unread_count: null,
                    mediaType: null,
                    mediaFileLength: null,
                    latestMessage: null,
                    status: null,
                    type: null,
                    fromMe: null,
                    messageTimestamp: null,
                    messageText: null,
                    grouping: "contact"
                });
                
            }
        }
        const chatQuery = `SELECT * FROM chats WHERE session = :session;`;

        const chatList = await sequelize.query(chatQuery, {
            replacements: { session: encrypt(session) },
            type: sequelize.QueryTypes.SELECT
        });

        let messagesByRemoteJid = {};


        for (const chat of chatList) {
            const decryptedRemoteJid = decrypt(chat.remoteJid);
            const decryptedMessageText = decrypt(chat.messageText);

            if (decryptedMessageText && decryptedMessageText.toLowerCase().includes(searchTerm)) {
                if (!messagesByRemoteJid[decryptedRemoteJid]) {
                    messagesByRemoteJid[decryptedRemoteJid] = [];
                }
                messagesByRemoteJid[decryptedRemoteJid].push({
                    messageTimestamp: chat.messageTimestamp,
                    messageText: decryptedMessageText,
                    id: chat.id,
                    fromMe: chat.fromMe,
                    pushName: chat.pushName,
                    status: chat.status,
                    message_id: chat.message_id,
                    remoteJid: decryptedRemoteJid,
                });
            }
        }
        
        const messages = [];

        for (const [remoteJid, messagesArray] of Object.entries(messagesByRemoteJid)) {
            const phone = remoteJid.split('@')[0];
            const encryptedPhone = encrypt(phone);
      
            const customerQuery = `
                SELECT name FROM customers 
                WHERE phone = :phone_customer;
            `;

            const customerList = await sequelize.query(customerQuery, {
                replacements: { phone_customer: encryptedPhone },
                type: sequelize.QueryTypes.SELECT
            });

  

            const pushname = customerList.length > 0 ? decrypt(customerList[0].name) : null;
            const profilePicture = getProfilePicture(remoteJid);
            
            const limitedMessages = messagesArray.slice(0, 3);
            
            let grouping = null;
            if (remoteJid.includes('@g.us')) {
                grouping = "group";
            }
            else {
                grouping = "message";
            }

            limitedMessages.forEach(message => {
                messages.push({
                    profilePicture: profilePicture,
                    pushName: pushname,
                    messageTimestamp: message.messageTimestamp,
                    messageText: message.messageText,
                    id: message.id,
                    fromMe: message.fromMe,
                    messageType: message.messageType,
                    mediaType: message.mediaType,
                    remoteJid: remoteJid,
                    status: message.status,
                    message_id: message.message_id,
                    grouping: grouping,
                });
            });
        }

        results.messages = messages;

        return res.status(200).json(results);

    } catch (error) {
        console.error('Error:', error);
        return res.status(500).json({ error: 'Internal Server Error' });
    }
}


async function broadcast(req, res) {

    const requiredPermission = 'create-activity-broadcast';

    if (!req.permissions.includes(requiredPermission)) {
        return res.status(403).json({ error: 'Kamu tidak memiliki izin untuk membuat broadcast' });
    }

    const created_by = req.user_id;

    const t = await sequelize.transaction();

    try {
        const { type, message, sender_number, campaign_name, target_numbers, delay_message, scheduled_time, notes, scheduled, session, company_id } = req.body;
        let status;

        if (type !== 'Draft' && type !== 'Submitted') {
            await t.rollback();
            return res.status(400).json({ error: "Invalid type" });
        }

        if (type === 'Submitted' && !scheduled) {
            status = 'Process';
        } else if (type === 'Submitted' && scheduled) {
            status = 'Pending';
        } else if (type === 'Draft') {
            status = 'Draft';
        }

        let totalCustomers = 0;
        if (target_numbers) {
            const customer_groups = await customer_group.findAll({ where: { group_id: target_numbers } });

            for (let i = 0; i < customer_groups.length; i++) {
                const group = customer_groups[i];
                const customersInGroup = await customers.findAll({ where: { id: group.customer_id } });
                totalCustomers += customersInGroup.length;
            }
        } else {
            return res.status(400).json({ error: "Invalid target_numbers" });
        }

        const encryptedMessage = encrypt(message);
        const encryptedSenderNumber = encrypt(sender_number);
        const encryptedCampaignName = encrypt(campaign_name);
        const encryptedNotes = encrypt(notes);

        const broadcast = await broadcasts.create({
            message : encryptedMessage,
            status,
            sender_number : encryptedSenderNumber,
            campaign_name : encryptedCampaignName,
            target_numbers,
            delay_message,
            scheduled_time,
            notes : encryptedNotes,
            scheduled,
            session,
            created_by,
            total_customer: totalCustomers,
            company_id,
        }, { transaction: t });

        await t.commit();

        if (type === 'Draft') {
            return res.status(200).json({ message: "Broadcast created successfully as draft", broadcast });
        }

        const id = broadcast.id;
        const sock = sockets[session];

        const group = await customer_group.findAll({ where: { group_id: target_numbers } });
        const customer_phone_numbers = [];

        const delay = ms => new Promise(resolve => setTimeout(resolve, ms));

        const sendMessages = async (processId) => {
            for (let i = 0; i < group.length; i++) {
                if (ongoingProcesses[processId]?.cancel) {
                    console.log(`Process ${processId} cancelled`);
                    await broadcasts.update({ status: 'Cancelled' }, { where: { id } });
                    return;
                }

                const customer = group[i];
                const customerData = await customers.findOne({ where: { id: customer.customer_id } });
                // const phoneNumber = customerData.phone + '@s.whatsapp.net';
                const phoneNumber = decrypt(customerData.phone) + '@s.whatsapp.net';
                customer_phone_numbers.push(phoneNumber);

                const messageDelay = i * delay_message * 1000;

                try {
                    await delay(messageDelay);
                    await retrySendMessage(sock, phoneNumber, message, 3);
                } catch (error) {
                    console.error("Error sending message to", phoneNumber, ":", error);
                }

                await broadcasts.update({ status: 'Success' }, { where: { id } });
            }
        };

        const retrySendMessage = async (sock, phoneNumber, message, retries) => {
            for (let attempt = 1; attempt <= retries; attempt++) {
                try {
                    const exists = await sock.onWhatsApp(phoneNumber);
                    if (exists) {
                        await sock.sendMessage(phoneNumber, { text: message })
                            .then(result => {
                                broadcast_logs.create({
                                    broadcast_id: id,
                                    // number: phoneNumber.replace(/\s/g, ''),
                                    number: encrypt(phoneNumber.replace(/\s/g, '')),
                                    message_id: result.key.id,
                                    status: 'Success',
                                    // sender_number: sender_number.replace(/\s/g, ''),
                                    sender_number: encrypt(sender_number.replace(/\s/g, '')),
                                    createdAt: new Date(),
                                    updatedAt: new Date()
                                });
                            });
                        break;
                    } else {
                        console.error("Number not found:", phoneNumber);
                        broadcast_logs.create({
                            broadcast_id: id,
                            number: encrypt(phoneNumber),
                            status: 'Failed',
                            sender_number: encrypt(sender_number),
                            message_id: null,
                            createdAt: new Date(),
                            updatedAt: new Date()
                        });
                    }
                } catch (error) {
                    if (attempt === retries) {
                        throw error;
                    }
                    console.warn(`Retrying to send message to ${phoneNumber} (Attempt ${attempt} of ${retries})`);
                    await delay(5000);
                }
            }
        };

        if (type === 'Submitted') {
            const processId = id;
            ongoingProcesses[processId] = { cancel: false };

            if (scheduled === 'true') {
                const jobDetails = {
                    broadcastId: id,
                    scheduledTime: new Date(scheduled_time),
                    status: 'Scheduled'
                };

                await jobs.create(jobDetails);

                const job = schedule.scheduleJob(new Date(scheduled_time), async () => {
                    try {
                        await sendMessages(processId);
                        await jobs.update({ status: 'Completed' }, { where: { broadcastId: processId } });
                        await jobs.destroy({ where: { broadcastId: processId } });
                    } catch (error) {
                        console.error(error);
                        await jobs.update({ status: 'Failed' }, { where: { broadcastId: processId } });
                    }
                });
                scheduledJobs[processId] = job;
                return res.status(200).json({ message: "Broadcast scheduled successfully", broadcast });
            }

            if (scheduled === 'false') {
                sendMessages(processId).then(async () => {
                    console.log("Messages sent successfully");
                    await jobs.destroy({ where: { broadcastId: processId } });
                }).catch(error => {
                    console.error("Error sending messages:", error);
                });
                return res.status(200).json({ message: "Broadcast created and messages are being sent", broadcast });
            }
        }
    } catch (error) {
        console.error("Error broadcast:", error);
        await t.rollback();
        return res.status(500).json({ error: "Internal server error" });
    }
}

async function rescheduleJobs() {
    const pendingJobs = await jobs.findAll({ where: { status: 'Scheduled' } });

    pendingJobs.forEach(job => {
        const { broadcastId, scheduledTime } = job;

        const jobFunc = async () => {
            const t = await sequelize.transaction();

            try {
                const broadcast = await broadcasts.findOne({ where: { id: broadcastId } });

                if (!broadcast) {
                    await jobs.update({ status: 'Failed' }, { where: { broadcastId } }, { transaction: t });
                    await jobs.destroy({ where: { broadcastId } }, { transaction: t });
                    await t.commit();
                    return;
                }

                const { message, sender_number, delay_message, target_numbers } = broadcast;
                const session = sender_number + '@s.whatsapp.net';
                const sock = sockets[session];
                const group = await customer_group.findAll({ where: { group_id: target_numbers } }, { transaction: t });
                const customer_phone_numbers = [];
                const delay = ms => new Promise(resolve => setTimeout(resolve, ms));
                const processId = broadcastId;

                const retrySendMessage = async (sock, phoneNumber, message, retries) => {
                    for (let attempt = 1; attempt <= retries; attempt++) {
                        try {
                            const exists = await sock.onWhatsApp(phoneNumber);
                            if (exists) {
                                await sock.sendMessage(phoneNumber, { text: message })
                                    .then(result => {
                                        broadcast_logs.create({
                                            broadcast_id: broadcastId,
                                            number: phoneNumber.replace(/\s/g, ''),
                                            message_id: result.key.id,
                                            status: 'Success',
                                            sender_number: sender_number.replace(/\s/g, ''),
                                            createdAt: new Date(),
                                            updatedAt: new Date()
                                        });
                                    });
                                break;
                            } else {
                                console.error("Number not found:", phoneNumber);
                                broadcast_logs.create({
                                    broadcast_id: broadcastId,
                                    number: phoneNumber,
                                    status: 'Failed',
                                    sender_number: sender_number,
                                    message_id: null,
                                    createdAt: new Date(),
                                    updatedAt: new Date()
                                });
                            }
                        } catch (error) {
                            if (attempt === retries) {
                                throw error;
                            }
                            console.warn(`Retrying to send message to ${phoneNumber} (Attempt ${attempt} of ${retries})`);
                            await delay(5000);
                        }
                    }
                };

                const sendMessages = async (processId) => {
                    for (let i = 0; i < group.length; i++) {
                        if (ongoingProcesses[processId]?.cancel) {
                            console.log(`Process ${processId} cancelled`);
                            await broadcasts.update({ status: 'Cancelled' }, { where: { id: processId } }, { transaction: t });
                            return;
                        }

                        const customer = group[i];
                        const customerData = await customers.findOne({ where: { id: customer.customer_id } }, { transaction: t });
                        const phoneNumber = customerData.phone + '@s.whatsapp.net';
                        customer_phone_numbers.push(phoneNumber);

                        const messageDelay = i * delay_message * 1000;

                        try {
                            await delay(messageDelay);
                            await retrySendMessage(sock, phoneNumber, message, 3);
                        } catch (error) {
                            console.error("Error sending message to", phoneNumber, ":", error);
                        }

                        await broadcasts.update({ status: 'Success' }, { where: { id: processId } }, { transaction: t });
                    }
                };

                await sendMessages(processId);
                await jobs.update({ status: 'Completed' }, { where: { broadcastId: processId } }, { transaction: t });
                await jobs.destroy({ where: { broadcastId: processId } }, { transaction: t });

                await t.commit();
            } catch (error) {
                console.error("Error in rescheduleJobs:", error);
                await t.rollback();
                await jobs.update({ status: 'Failed' }, { where: { broadcastId } });
            }
        };

        if (new Date(scheduledTime) > new Date()) {
            schedule.scheduleJob(new Date(scheduledTime), jobFunc);
        } else {
            jobFunc();
        }
    });
}


async function editBroadcast(req, res) {

    const requiredPermission = 'update-activity-broadcast';

    if (!req.permissions.includes(requiredPermission)) {
        return res.status(403).json({ error: 'Kamu tidak memiliki izin untuk mengedit broadcast' });
    }
        

    const t = await sequelize.transaction();

    try {
        const { broadcast_id, message, sender_number, campaign_name, target_numbers, delay_message, scheduled_time, notes, scheduled, session, type } = req.body;
        const broadcast = await broadcasts.findOne({ where: { id: broadcast_id } });

        if (!broadcast) {
            await t.rollback();
            return res.status(404).json({ error: "Broadcast not found" });
        }

        if (broadcast.status === 'Success' || broadcast.status === 'Cancelled') {
            await t.rollback();

            return res.status(400).json({ error: "Broadcast cannot be edited" });
        }

        if (scheduledJobs[broadcast_id]) {
            scheduledJobs[broadcast_id].cancel();
            delete scheduledJobs[broadcast_id];
        }

        if (ongoingProcesses[broadcast_id]) {
            ongoingProcesses[broadcast_id].cancel = true;
        }

        const encryptedMessage = encrypt(message);
        const encryptedSenderNumber = encrypt(sender_number);
        const encryptedCampaignName = encrypt(campaign_name);
        const encryptedNotes = encrypt(notes);

        await broadcasts.update({
            // message, encrypted message if null then keep the old message
            message: encryptedMessage || broadcast.message,
            sender_number: encryptedSenderNumber || broadcast.sender_number,
            campaign_name : encryptedCampaignName || broadcast.campaign_name,
            target_numbers : target_numbers || broadcast.target_numbers,
            delay_message : delay_message || broadcast.delay_message,
            scheduled_time : scheduled_time || broadcast.scheduled_time,
            notes : encryptedNotes || broadcast.notes,
            scheduled : scheduled || broadcast.scheduled,
            session, 
        }, { where: { id: broadcast_id }, transaction: t });

        await t.commit();

        if (type === 'Draft') {
            return res.status(200).json({ message: "Broadcast updated successfully", broadcast });
        }

       
        const id = broadcast_id;
        const sock = sockets[session];

        const group = await customer_group.findAll({ where: { group_id: target_numbers } });
        const customer_phone_numbers = [];

        const delay = ms => new Promise(resolve => setTimeout(resolve, ms));

        const sendMessages = async (processId) => {
            for (let i = 0; i < group.length; i++) {
                if (ongoingProcesses[processId]?.cancel) {
                    console.log(`Process ${processId} cancelled`);
                    await broadcasts.update({ status: 'Cancelled' }, { where: { id } });
                    return;
                }

                const customer = group[i];
                const customerData = await customers.findOne({ where: { id: customer.customer_id } });
                // const phoneNumber = customerData.phone + '@s.whatsapp.net';
                const phoneNumber = decrypt(customerData.phone) + '@s.whatsapp.net';
                customer_phone_numbers.push(phoneNumber);

                const messageDelay = i * delay_message * 1000;

                try {
                    await delay(messageDelay);
                    await retrySendMessage(sock, phoneNumber, message, 3);
                } catch (error) {
                    console.error("Error sending message to", phoneNumber, ":", error);
                }

                await broadcasts.update({ status: 'Success' }, { where: { id } });
            }
        };

        const retrySendMessage = async (sock, phoneNumber, message, retries) => {
            for (let attempt = 1; attempt <= retries; attempt++) {
                try {
                    const exists = await sock.onWhatsApp(phoneNumber);
                    if (exists) {
                        await sock.sendMessage(phoneNumber, { text: message })
                        .then(result => {
                            broadcast_logs.create({
                                broadcast_id: id,
                                // number: phoneNumber.replace(/\s/g, ''),
                                number: encrypt(phoneNumber.replace(/\s/g, '')),
                                message_id: result.key.id,
                                status: 'Success',
                                // sender_number: sender_number.replace(/\s/g, ''),
                                sender_number: encrypt(sender_number.replace(/\s/g, '')),
                                createdAt: new Date(),
                                updatedAt: new Date()
                            });
                        }
                        );
                        break;
                    }
                    else {
                        console.error("Number not found:", phoneNumber);
                        broadcast_logs.create({
                            broadcast_id: id,
                            // number: phoneNumber,
                            number: encrypt(phoneNumber),
                            status: 'Failed',
                            // sender_number: sender_number,
                            number: encrypt(sender_number),
                            message_id: null,
                            createdAt: new Date(),
                            updatedAt: new Date()
                        });
                    }
                } catch (error) {
                    if (attempt === retries) {
                        throw error;
                    }
                    console.warn(`Retrying to send message to ${phoneNumber} (Attempt ${attempt} of ${retries})`);
                    await delay(5000);
                }
            }
        };

        if (type === 'Submitted') {
            const processId = id; 
            ongoingProcesses[processId] = { cancel: false }; 
            
            await broadcasts.update({ status: 'Pending' }, { where: { id } });

            if (scheduled === 'true') {
                const job = schedule.scheduleJob(new Date(scheduled_time), async () => {
                    try {
                        await sendMessages(processId);
                    } catch (error) {
                        console.error(error);
                    }
                });
                scheduledJobs[processId] = job; 
                return res.status(200).json({ message: "Broadcast scheduled successfully", broadcast });
            } 
            if (scheduled === 'false') {
                sendMessages(processId).then(() => {
                    console.log("Messages sent successfully");
                }).catch(error => {
                    console.error("Error sending messages:", error);
                });
                return res.status(200).json({ message: "Broadcast created and messages are being sent", broadcast });
            }
        }
    } catch (error) {
        console.error("Error editing broadcast:", error);
        await t.rollback();
        return res.status(500).json({ error: "Internal server error" });
    }
}
        
async function cancelBroadcast(req, res) {

    const requiredPermission = 'cancel-activity-broadcast';

    if (!req.permissions.includes(requiredPermission)) {
        return res.status(403).json({ error: 'Kamu tidak memiliki izin untuk membatalkan broadcast' });
    }

    const { id } = req.body;
    
    if (scheduledJobs[id]) {
        scheduledJobs[id].cancel();
        delete scheduledJobs[id];
        await broadcasts.update({ status: 'Cancelled' }, { where: { id } });
        return res.status(200).json({ message: "Scheduled broadcast cancelled successfully" });
    }

    if (ongoingProcesses[id]) {
        ongoingProcesses[id].cancel = true;
        return res.status(200).json({ message: "Ongoing broadcast process cancelled successfully" });
    }

    return res.status(404).json({ error: "Broadcast not found or already completed" });
}


async function SearchMessage(req, res) {
    const session = req.query.session;
    const number = req.query.number;
    const keyword = req.query.keyword;
    const id = session + '@s.whatsapp.net';

    try {
        const encrypted_number = encrypt(number);
        const encrypted_id = encrypt(id);

        const chats = await sequelize.query(
            `SELECT * FROM chats 
                WHERE session = :session 
                AND "remoteJid" = :remoteJid 
                ORDER BY "createdAt" DESC`,
            {
                replacements: { session: encrypted_id, remoteJid: encrypted_number },
                type: QueryTypes.SELECT
            }
        );

        if (!chats || chats.length === 0) {
            return res.status(404).json({ error: 'Chat history not found' });
        }

        const decryptedChats = chats.map(chat => {
            chat.messageText = decrypt(chat.messageText);
            return chat;
        });

        const filteredChats = decryptedChats.filter(chat => chat.messageText.toLowerCase().includes(keyword.toLowerCase()));

        if (!filteredChats || filteredChats.length === 0) {
            return res.status(404).json({ error: 'Chat history not found' });
        }

        const data = [];

        const mediaMessageTypes = [
            'documentMessage', 'documentWithCaptionMessage', 'imageMessage',
            'videoMessage', 'audioMessage', 'stickerMessage'
        ];
        const messageIds = filteredChats
            .filter(message => mediaMessageTypes.includes(message.messageType))
            .map(message => message.message_id);

        let mediaDataMap = {};
        if (messageIds.length > 0) {
            const mediaData = await sequelize.query(
                `SELECT * FROM media_data_details WHERE id_messsage IN (:messageIds)`,
                {
                    replacements: { messageIds },
                    type: QueryTypes.SELECT
                }
            );

            mediaDataMap = mediaData.reduce((acc, media) => {
                acc[media.id_message] = media.media_data_name;
                return acc;
            }, {});
        }

        for (const message of filteredChats) {
            const message_data = {
                remoteJid: decrypt(message.remoteJid),
                messageTimestamp: message.messageTimestamp,
                messageText: message.messageText,
                id: message.id,
                fromMe: message.fromMe,
                pushName: message.pushName,
                status: message.status,
                messageType: message.messageType,
                mediaType: message.mediaType,
                mediaFileLength: message.mediaFileLength,
                createdAt: message.createdAt,
                updatedAt: message.updatedAt,
                message_id: message.message_id,
                contextInfo_stanzaId: message.contextInfo_stanzaId,
                contextInfo_participant: message.contextInfo_participant,
                contextInfo_messageType: message.contextInfo_messageType,
                type: message.type,
                participant: message.participant,
                unread_count: message.unread_count,
                media_data_name: message.media_data_name
            };

            if (mediaMessageTypes.includes(message.messageType)) {
                const mediaDataName = mediaDataMap[message.message_id];
                if (mediaDataName) {
                    message_data.media_data_name = mediaDataName;
                    message_data.document_path = `/media/${mediaDataName}`;
                }
            }

            data.push(message_data);
        }

        res.status(200).json({ messages: data });

    } catch (error) {
        console.error('Error handling search request:', error);
        return res.status(500).json({ error: 'Internal server error' });
    }
}


async function InfoNumberWhatsapp(req, res) {
    const token = req.query.session;
    const session = token + '@s.whatsapp.net';
    const sock = sockets[session];
    try {
        if (!sock) {
            return res.status(400).json({ error: "Soket tidak ditemukan" });
        }

        const user = sock.user;
        if (!user || !user.id) {
            return res.status(400).json({ error: "ID whatsapp tidak ditemukan" });
        }

        const id = user.id.split(':')[0] + '@s.whatsapp.net';
        const pictureFileName = `${id}_profile_picture.jpg`;
        const picturePath = path.join(__dirname, '../media', pictureFileName);

        let pictureToSend = 'default.jpg'; 

        if (fs.existsSync(picturePath)) {
            pictureToSend = pictureFileName;
        }

        user.profilePicture = pictureToSend;

        res.status(200).json({ user });
    } catch (err) {
        res.status(500).json({ error: "Internal server error" + err });
    }

}


async function updateProfilePicture(req, res) {
    const session = req.body.session;
    const sock = sockets[session];

    try{
    
        if (!sock || !sock.user || !sock.user.id) {
            return res.status(400).json({ error: 'ID whatsapp tidak ditemukan' });
        }

        const jid = sock.user.id;

    }
    catch(err){
        console.error(err);
        return res.status(500).json({ error: 'Internal server error' });
    }
    try {
        if (!sock || !sock.user || !sock.user.id) {
            return res.status(400).json({ message: 'ID whatsapp tidak ditemukan' });
        }
        const jid = sock.user.id ? sock.user.id.split(':')[0] + '@s.whatsapp.net' : null; 
     
        if (!req.files || !req.files.picture || req.files.picture.size === 0) {
            if (!req.body.name) {
                return res.status(400).json({ message: 'Nama tidak ditemukan' });
            }

            await sock.updateProfileName(req.body.name);

            await sock.restart();

            return res.status(200).json({ message: 'Nama profil diperbarui dengan sukses', 'jid': jid });
        }

      if (req.files && !req.files.picture) {
            await sock.removeProfilePicture(jid);
            const id = jid.split(':')[0] + '@s.whatsapp.net';
            const picturePath = path.join(__dirname, '../media', `${id}` + '_profile_picture.jpg');
            if (fs.existsSync(picturePath)) {
                fs.unlinkSync(picturePath);
            }
            return res.status(200).json({ message: 'Gambar profil dihapus dengan sukses' });
        }

        const picture = req.files.picture;
        const id = jid.split(':')[0] + '@s.whatsapp.net';
        const picturePath = path.join(__dirname, '../media', `${id}` + '_profile_picture.jpg');

        await picture.mv(picturePath);
        await sock.updateProfilePicture(jid, { url: picturePath });

        if (req.body && req.body.name) {
            const newName = req.body.name;
            await sock.updateProfileName(newName);
        }

        //restart the session to apply the changes
        // await sock.restart();

        return res.status(200).json({ message: 'Profil diperbarui dengan sukses', 'jid': jid });

    } catch (error) {
        console.error("Error updating profile:", error);
        return res.status(500).json({ message: 'Kesalahan internal server' });
    }
}

async function deleteMessage(req, res) {

    const session = req.body.session;
    const sock = sockets[session];
    const id = req.body.id;
    const jid = req.body.jid;
    const fromMe = req.body.from_me;
    const id_message = req.body.id_message;
    const key = {
        remoteJid: id,
        fromMe: fromMe,
        id: id_message
    }
    try {
        if (!sock) {
            return res.status(500).json({ error: 'Session not found' });
        }
        await sock.sendMessage(jid, { delete: key });
        return res.status(200).json({ message: 'Message deleted successfully' });
    }

    catch (error) {
        console.error("Error deleting message:", error);
        return res.status(500).json({ error: 'Internal server error' });
    }

}

async function startConnections() {
    try {
        const sessionst = await devices.findAll({ where: { status: 'Active' } });
        for (let i = 0; i < sessionst.length; i++) {
            const release = await mutex.acquire();
            try {
                const session = decrypt(sessionst[i].session);
                await connectToWhatsApp(session);

            } finally {
                release();
            }
        }
        console.log("All connections established successfully.");
    } catch (err) {
        console.log("Unexpected error:", err);
    }
}

const isSessionActive = async (session) => {
    const sock = sockets[session];
    if (!sock || !sock.user) {
        console.log("Session not found");
        return false;
    }
    console.log("Session found");
    return true;
}

async function get_progress_backup(req, res) {
    const session = req.query.session;
    const encryptedSession = encrypt(session);
    const backupPath = path.join(__dirname, '../backup', session + '@s.whatsapp.net.json');
    const secretKey = process.env.ENCRYPTION_KEY;

    try {
        const chat = await readEncryptedFile(backupPath, secretKey);
        if (!chat) {
            return res.status(404).json({ error: 'Backup not found' });
        }

        const totalMessages = chat.messages.length;
        const totalContacts = Object.keys(chat.contacts).length;

        return res.status(200).json({ totalMessages, totalContacts });
    } catch (error) {
        console.error("Error getting backup progress:", error);
        return res.status(500).json({ error: 'Internal server error' });
    }
}

async function initializeConnections(sessionsts) {
    if (!sessionsts) {
        return { error: 'Session not provided' };
    }
    try {
        if (await isSessionActive(sessionsts)) {
            return { status: 'WhatsApp is already connected' };
        } else {
            const qrCodeData = await initializeConnection(sessionsts);
            if (qrCodeData) {
                const qrImage = qr_image.imageSync(qrCodeData, { type: 'png' });
                const base64QR = qrImage.toString('base64');
                return { qrCode: base64QR };
            } else {
                return { error: "QR code not available" };
            }
        }
    } catch (error) {
        console.error("Error occurred:", error);
        throw error;
    }
}



async function logoutWhatsApp(req, res) {
    const session = req.query.session;
    const encryptedSession = encrypt(session);
    try {
        if (!session || !sockets[session]) {
            return res.status(400).json({ error: 'Invalid session or session not found' });
        }

        const sock = sockets[session];
        await sock.logout();
        // fs.rmdirSync(`./session/${session }`, { recursive: true });
      
        // const device = await devices.findOne({ where: { session:encryptedSession } });
        // if (device) {
        //     await device.update({ status: 'Inactive' });
        // } else {
        //     return res.status(500).json({ error: 'Device not found' });
        // }

        delete stores[session];
        delete sockets[session];

        return res.status(200).json({ message: 'Logout successful' });
    } catch (error) {
        console.error('Error in logoutWhatsApp:', error);
        return res.status(500).json({ error: 'Internal server error' });
    }
}

async function deleteDevices(req, res) {
    const session = req.query.session;
    const id = req.query.id;

    try {
        // Check if session exists in sockets
        if (!session || !sockets[session]) {
            // Session not found in sockets, delete device directly
            const device = await devices.findOne({ where: { id } });
            if (device) {
                await device.destroy();
            }
        } else {
            // Logout from socket and delete session-related data
            const sock = sockets[session];
            await sock.logout(); // Assuming sock.logout() is asynchronous and handles logout

            // Delete device associated with the id
            const device = await devices.findOne({ where: { id } });
            if (device) {
                await device.destroy();
            }

            // Clean up session data
            delete stores[session];
            delete sockets[session];
        }

        // Respond with success message
        return res.status(200).json({ message: 'Device deleted successfully' });
    } catch (error) {
        // Handle errors
        console.error('Error in deleteDevices:', error);
        return res.status(500).json({ error: 'Internal server error' });
    }
}



async function importContacts(req, res) {
    const session = req.body.session;
    const company_id = req.body.company_id;

    if (!company_id) {
        return res.status(400).json({ error: 'Company id does not exist' });
    }

    const backupPath = path.join(__dirname, '../backup', session + '@s.whatsapp.net.json');
    if (!fs.existsSync(backupPath)) {
        return res.status(404).json({ error: 'Backup not found' });
    }

    try {
        const secretKey = process.env.ENCRYPTION_KEY;
        const chat = readEncryptedFile(backupPath, secretKey);
        if (!chat) {
            console.log("Decryption failed or file not found");
            return res.status(404).json({ error: 'Decryption failed or file not found' });
        }

        const contacts = [];

        for (const [number, contact] of Object.entries(chat.contacts)) {
            if ((number.includes('@s.whatsapp.net') || number.includes('@g.us')) && (contact.name || contact.notify)) {
                const contactName = contact.name ? contact.name : contact.notify;
                const phoneNumber = number.split('@')[0];
                const type = number.includes('@s.whatsapp.net') ? 'customer' : 'group';

                const encryptedNumber = encrypt(phoneNumber);
                const encryptedName = encrypt(contactName);

                const existingCustomer = await customers.findOne({
                    where: {
                        company_id: company_id,
                        // name: encryptedName,
                        phone: encryptedNumber
                    }
                });

                if (!existingCustomer) {
                    contacts.push({ number: phoneNumber, contact });
                    await customers.create({
                        company_id: company_id,
                        name: encryptedName,
                        phone: encryptedNumber,
                        email: null,
                        createdAt: new Date(),
                        updatedAt: new Date(),
                        type: type
                    }).catch(error => {
                        console.error(`Error creating ${type}:`, error);
                    });
                }
            }
        }
        return res.status(200).json({ message: 'Contacts imported successfully' });
    } catch (error) {
        console.error("Error importing contacts:", error);
        return res.status(500).json({ error: 'Internal server error' });
    }
}
const decryptE = (cipherText) => {
    try {
        const bytes = crypto.AES.decrypt(cipherText, secretKey);
        return bytes.toString(crypto.enc.Utf8);
    } catch (error) {
        console.error('Error decrypting data:', error);
        return null;
    }
};


async function importM(req, res) {
    const session = req.body.session;
    const user_id = req.body.user_id;
    const storeFileName = session + '@s.whatsapp.net.json';
    const storePath = path.join(__dirname, '../backup', storeFileName);
    const transaction = await sequelize.transaction();

    try {
        const encryptedData = fs.readFileSync(storePath, 'utf8');
        const storeData = decryptE(encryptedData, secretKey);

        if (!storeData) {
            console.log('Decryption failed for store data');
            return res.status(404).json({ error: 'Data not found' });
        }

        const token = session + '@s.whatsapp.net';
        const parsedData = JSON.parse(storeData);
        const messagesData = parsedData.messages;

        if (!messagesData) {
            console.log('Invalid message data structure');
            return res.status(400).json({ error: 'Invalid message data' });
        }

        const days = req.body.days || 3; 
        const currentDate = new Date();
        const previousDate = new Date(currentDate.getTime() - (days * 24 * 60 * 60 * 1000));

        console.log('Current Date and Time:', currentDate);
        console.log('Date and Time', days, 'days ago:', previousDate);

        const start_date = new Date(currentDate.getTime() - (days * 24 * 60 * 60 * 1000));
        const end_date = currentDate;

        const allPhoneNumbers = await chat_numbers.findAll({ transaction });
        const decryptedPhoneNumbers = new Map(
            allPhoneNumbers.map(entry => [decrypt(entry.phone_number), entry.id])
        );

        const newMessages = [];
        const updateMessages = [];
        const messageIds = [];
        const remoteJidSet = new Set();

        const existingMessages = await chats.findAll({
            where: { message_id: { [Op.in]: messageIds } },
            transaction
        });

        const existingMessageIds = new Set(existingMessages.map(msg => msg.message_id));

        for (const [key, messages] of Object.entries(messagesData)) {
            if (key.includes('@lid')) {
                console.log(`Skipping messages for remoteJid with @lid: ${key}`);
                continue;
            }
            for (const message of messages) {
                const { key: messageKey, messageTimestamp, pushName, broadcast, status, participant, messageStubType } = message;

                if (messageStubType === 'E2E_ENCRYPTED') {
                    console.log(`Skipping message with E2E_ENCRYPTED stub type: ${messageKey.id}`);
                    continue;
                }

                const messageDate = new Date(parseInt(messageTimestamp) * 1000);

                if (messageDate < previousDate || messageDate > currentDate) {
                    console.log('Skipping message with timestamp:', messageTimestamp);
                    continue;
                }

                if (existingMessageIds.has(messageKey.id)) {
                    console.log('Skipping message with existing message_id:', messageKey.id);
                    continue;
                }

                let messageText = '';
                let contextInfo_stanzaId = null;
                let contextInfo_participant = null;
                let contextInfo_messageType = null;

                if (message.message) {
                    if (message.message.extendedTextMessage && message.message.extendedTextMessage.text) {
                        messageText = message.message.extendedTextMessage.text;
                        contextInfo_stanzaId = message.message.extendedTextMessage.contextInfo?.stanzaId || null;
                        contextInfo_participant = message.message.extendedTextMessage.contextInfo?.participant || null;
                    } else if (message.message.conversation) {
                        messageText = message.message.conversation;
                    } else if (message.message.videoMessage) {
                        messageText = message.message.videoMessage.caption;
                    } else if (message.message.documentMessage) {
                        messageText = message.message.documentMessage.caption;
                    } else if (message.message.documentWithCaptionMessage) {
                        const documentMessage = message.message.documentWithCaptionMessage.message.documentMessage;
                        if (documentMessage && documentMessage.caption) {
                            messageText = documentMessage.caption;
                        }
                    } else if (message.message.imageMessage) {
                        messageText = message.message.imageMessage.caption;
                    }
                }

                if (message.message && message.message.extendedTextMessage) {
                    if (message.message.extendedTextMessage.contextInfo?.quotedMessage?.videoMessage) {
                        contextInfo_messageType = 'videoMessage';
                    } else if (message.message.extendedTextMessage.contextInfo?.quotedMessage?.documentMessage) {
                        contextInfo_messageType = 'documentMessage';
                    } else if (message.message.extendedTextMessage.contextInfo?.quotedMessage?.imageMessage) {
                        contextInfo_messageType = 'imageMessage';
                    }
                }

                let messageType = null;
                let mediaType = null;
                let mediaFileLength = null;
                let mediaUrl = null;

                if (message.message) {
                    if (message.message.videoMessage) {
                        messageType = 'videoMessage';
                        mediaType = message.message.videoMessage.mimetype;
                        mediaFileLength = message.message.videoMessage.fileLength;
                        mediaUrl = message.message.videoMessage.url;
                    } else if (message.message.documentMessage) {
                        messageType = 'documentMessage';
                        mediaType = message.message.documentMessage.mimetype;
                        mediaFileLength = message.message.documentMessage.fileLength;
                        mediaUrl = message.message.documentMessage.url;
                    } else if (message.message.imageMessage) {
                        messageType = 'imageMessage';
                        mediaType = message.message.imageMessage.mimetype;
                        mediaFileLength = message.message.imageMessage.fileLength;
                        mediaUrl = message.message.imageMessage.url;
                    } else if (message.message.audioMessage) {
                        messageType = 'audioMessage';
                        mediaType = message.message.audioMessage.mimetype;
                        mediaFileLength = message.message.audioMessage.fileLength;
                        mediaUrl = message.message.audioMessage.url;
                    } else if (message.message.stickerMessage) {
                        messageType = 'stickerMessage';
                        mediaType = message.message.stickerMessage.mimetype;
                        mediaFileLength = message.message.stickerMessage.fileLength;
                        mediaUrl = message.message.stickerMessage.url;
                    }
                }

                if (message.message && message.message.documentWithCaptionMessage) {
                    messageType = 'documentWithCaptionMessage';
                    mediaType = message.message.documentWithCaptionMessage.message.documentMessage.mimetype;
                    mediaFileLength = message.message.documentWithCaptionMessage.message.documentMessage.fileLength;
                    mediaUrl = message.message.documentWithCaptionMessage.message.documentMessage.url;
                }

                const encryptedRemoteJid = encrypt(messageKey.remoteJid);
                const encryptedMessageText = encrypt(messageText);
                const encryptedSession = encrypt(token);
                const encryptedParticipant = encrypt(message.participant || null);

                messageIds.push(messageKey.id);
                remoteJidSet.add(messageKey.remoteJid);

                if (message.message?.protocolMessage?.type === 0) {
                    const notifyMessage = await chats.findOne({ where: { message_id: message.message.protocolMessage.key.id }, transaction });
                    if (notifyMessage) {
                        await chats.update({ type: 'REVOKE' }, { where: { message_id: message.message.protocolMessage.key.id }, transaction });
                    }
                } else {
                    newMessages.push({
                        message_id: messageKey.id,
                        session: encryptedSession,
                        remoteJid: encryptedRemoteJid,
                        fromMe: messageKey.fromMe,
                        messageTimestamp,
                        pushName,
                        status,
                        messageText: encryptedMessageText,
                        isBroadcast: broadcast,
                        messageType,
                        mediaType,
                        mediaFileLength,
                        contextInfo_stanzaId,
                        contextInfo_participant,
                        contextInfo_messageType,
                        participant: encryptedParticipant,
                        type: 'ACTIVE'
                    });
                }
            }
        }

        const newPhoneNumbers = Array.from(remoteJidSet).filter(remoteJid => !decryptedPhoneNumbers.has(remoteJid));

        if (newPhoneNumbers.length > 0) {
            const newNumberEntries = await chat_numbers.bulkCreate(newPhoneNumbers.map(remoteJid => ({
                phone_number: encrypt(remoteJid)
            })), { transaction });

            newNumberEntries.forEach(entry => decryptedPhoneNumbers.set(decrypt(entry.phone_number), entry.id));
        }

        const messagesToInsert = newMessages.filter(msg => !existingMessageIds.has(msg.message_id));
        const messagesToUpdate = newMessages.filter(msg => existingMessageIds.has(msg.message_id));

        if (messagesToInsert.length > 0) {
            const batchSize = 10000;
            for (let i = 0; i < messagesToInsert.length; i += batchSize) {
                const batch = messagesToInsert.slice(i, i + batchSize);
                await chats.bulkCreate(batch.map(msg => ({
                    ...msg,
                    phone_number_id: decryptedPhoneNumbers.get(decrypt(msg.remoteJid))
                })), { transaction });
            }
        }

        if (messagesToUpdate.length > 0) {
            for (const msg of messagesToUpdate) {
                await chats.update({
                    ...msg,
                    phone_number_id: decryptedPhoneNumbers.get(decrypt(msg.remoteJid))
                }, {
                    where: { message_id: msg.message_id },
                    transaction
                });
            }
        }

        await transaction.commit();

        const encryptedSession = encrypt(token);

        await chat_sync_logs.create({
            session: encryptedSession,
            start_time: start_date,
            user_id: user_id,
            end_time: end_date,
            createdAt: new Date(),
            updatedAt: new Date()
        });
        return res.status(200).json({ message: 'Messages imported successfully' });
    } catch (error) {
        await transaction.rollback();
        console.error('Error performing CRUD operation:', error);
        res.status(500).json({ error: 'Internal Server Error' });
    }
}


async function add_alocation_chat(req, res) {
    const { user_id, session_number, customer_number } = req.body;

    const encryptedCustomerNumber = encrypt(customer_number);
    const encryptedSessionNumber = encrypt(session_number + '@s.whatsapp.net');

    if (!encryptedSessionNumber || !encryptedCustomerNumber) {
        return res.status(400).json({ error: 'Session number or customer number not provided' });
    }

    try {
        await user_chat_accesses.create({
            user_id: user_id,
            session_number: encryptedSessionNumber,
            customer_number: encryptedCustomerNumber
        });
        return res.status(200).json({ message: 'Chat access added successfully' });
    }

    catch (error) {
        console.error("Error adding chat access:", error);
        return res.status(500).json({ error: 'Internal server error' });
    }

}

async function delete_alocation_chat(req, res) {
    const { user_id, session_number, customer_number, company_id } = req.body;

    const encryptedCustomerNumber = encrypt(customer_number);
    const encryptedSessionNumber = encrypt(session_number + '@s.whatsapp.net');

    if (!encryptedSessionNumber || !encryptedCustomerNumber) {
        return res.status(400).json({ error: 'Session number or customer number not provided' });
    }

    try {
        await user_chat_accesses.destroy({
            where: {
                user_id: user_id,
                session_number: encryptedSessionNumber,
                customer_number: encryptedCustomerNumber,
            }
        });

        await chat_history_users.update({ status_chat: true }, {
            where: {
                session: encryptedSessionNumber,
                customer_number: encryptedCustomerNumber,
                company_id: company_id
            }
        });

        return res.status(200).json({ message: 'Chat access removed successfully' });
    }
    
    catch (error) {
        console.error("Error removing chat access:", error);
        return res.status(500).json({ error: 'Internal server error' });
    }   

}

async function resetUnreadCount(session, number) {

    const session_id = session + '@s.whatsapp.net';
    const number_id = number;

    const encryptedNumber = encrypt(number_id);
    const encryptedId = encrypt(session_id);

    if (!encryptedNumber || !encryptedId) {
        return { message: 'Unread count reset successfully' };
    }

    try {

        await notifications.update({ unread_count: 0 }, {
            where: {
                sender_phone_number: encryptedId,
                phone_number: encryptedNumber
            }
        });

        return { message: 'Unread count reset successfully' };

    } catch (error) {
        console.error("Error resetting unread count:", error);
        throw new Error('Internal server error');
    }
}


async function all_chat_sync_logs(req, res) {
    const session = req.query.session;

    const encryptedSession = encrypt(session + '@s.whatsapp.net');

    if (!encryptedSession) {
        return res.status(400).json({ error: 'Session not provided' });
    }

    try {
        const logs = await chat_sync_logs.findAll({
            where: {
                session: encryptedSession, 
            }
        });

        for (let i = 0; i < logs.length; i++) {
            const user = await users.findOne({ where: { id: logs[i].user_id } });
            logs[i].user_id = decrypt(user.name);
            logs[i].session = decrypt(logs[i].session);
        }

        return res.status(200).json({ logs });

    } catch (error) {
        console.error("Error fetching sync logs:", error);
        return res.status(500).json({ error: 'Internal server error' });
    }
}

const  detail_allocation_chat = async (req, res) => {
    const session = req.query.session;
    const number = req.query.number;

    const encryptedNumber = encrypt(number);
    const encryptedSession = encrypt(session);

    if (!encryptedNumber || !encryptedSession) {
        return res.status(400).json({ error: 'Session or number not provided' });
    }
    try {
        const chat_access = await user_chat_accesses.findAll({
            where: {
                session_number: encryptedSession,
                customer_number: encryptedNumber
            },
            include: [
                { model: users, as: 'user', attributes: ['name', 'id'] }
            ]
        });

        console.log(chat_access);

        for (let i = 0; i < chat_access.length; i++) {
            //console.log(chat_access[i].user.name);
            console.log(chat_access[i].user);
            if (chat_access[i].user) {
                chat_access[i].user.name = decrypt(chat_access[i].user.name || '');
            }
            chat_access[i].session_number = decrypt(chat_access[i].session_number);
            chat_access[i].customer_number = decrypt(chat_access[i].customer_number);
        }
        

        return res.status(200).json({ chat_access });

    } catch (error) {
        console.error("Error fetching chat access:", error);
        return res.status(500).json({ error: 'Internal server error' });
    }
}

async function countUnreadCount(req, res) {
    const { session, user_id } = req.query;

    if (!session) {
        return res.status(400).json({ error: 'Session not provided' });
    }
    const encryptedSession = encrypt(session + '@s.whatsapp.net');

    try {
        const roleQuery = `SELECT role FROM users WHERE id = :user_id`;
        const [roleResult] = await sequelize.query(roleQuery, {
            replacements: { user_id },
            type: QueryTypes.SELECT
        });

        if (!roleResult || !roleResult.role) {
            return res.status(404).json({ error: 'Role not found' });
        }

        const role = roleResult.role.toLowerCase();

        if (role.includes('admin') || role.includes('super admin')) {
            const unreadNotifications = await notifications.findAll({
                where: { sender_phone_number: encryptedSession },
                attributes: [[sequelize.fn('sum', sequelize.col('unread_count')), 'total_unread_count']]
            });

            const totalUnreadCount = unreadNotifications[0]?.dataValues?.total_unread_count || 0;

            return res.status(200).json({ total_unread_count: totalUnreadCount });
        }

        if (role.includes('user')) {
            const chatAccesses = await user_chat_accesses.findAll({
                where: { user_id, session_number: encryptedSession },
                attributes: ['customer_number']
            });

            const customerNumbers = chatAccesses.map(access => access.customer_number);

            if (customerNumbers.length === 0) {
                return res.status(200).json({ total_unread_count: 0 });
            }
            const unreadNotifications = await notifications.findAll({
                where: {
                    sender_phone_number: encryptedSession,
                    phone_number: customerNumbers
                },
                attributes: [[sequelize.fn('sum', sequelize.col('unread_count')), 'total_unread_count']]
            });

            const totalUnreadCount = unreadNotifications[0]?.dataValues?.total_unread_count || 0;

            return res.status(200).json({ total_unread_count: totalUnreadCount });
        }

        return res.status(403).json({ error: 'You do not have permission to access this data' });
    } catch (error) {
        console.error('Error:', error);
        return res.status(500).json({ error: 'Internal server error' });
    }
}
// const message_image = {
//     "key": {
//         "remoteJid": "6285881594312@s.whatsapp.net",
//         "fromMe": false,
//         "id": "881076AA3FBAF1F682"
//     },
//     "messageTimestamp": 1721035235,
//     "pushName": "Wahyu Widi Widayat",
//     "broadcast": false,
//     "message": {
//         "documentMessage": {
//             "url": "https://mmg.whatsapp.net/v/t62.7119-24/11811765_1649191488955462_1877354978821041786_n.enc?ccb=11-4&oh=01_Q5AaIABLsOL5o5M1I0tePEsFVBqBrcyRe2LERtGFbs0u7dTB&oe=66BC7247&_nc_sid=5e03e0&mms3=true",
//             "mimetype": "application/pdf",
//             "title": "Pricelist Juni 2024.pdf",
//             "fileSha256": "BlHXCBr0MzLs9IGFGRuvgCoQAu4ZyMC+d/zeu7j9T20=",
//             "fileLength": "25593",
//             "pageCount": 1,
//             "mediaKey": "qzZuF3WX9GCwTSKl9bRccn4DWynHb6Q8m+Q0CTmrezE=",
//             "fileName": "Pricelist Juni 2024.pdf",
//             "fileEncSha256": "45hng4iHow5Gk7cz9ZS3FK5ocDmx12dyF7cuu+RaTb8=",
//             "directPath": "/v/t62.7119-24/11811765_1649191488955462_1877354978821041786_n.enc?ccb=11-4&oh=01_Q5AaIABLsOL5o5M1I0tePEsFVBqBrcyRe2LERtGFbs0u7dTB&oe=66BC7247&_nc_sid=5e03e0",
//             "mediaKeyTimestamp": "1721030087"
//         },
//         "messageContextInfo": {
//             "deviceListMetadata": {
//                 "senderKeyHash": "whsaqI0AEmexXw==",
//                 "senderTimestamp": "1720516212",
//                 "recipientKeyHash": "11r5Pym5dl64DQ==",
//                 "recipientTimestamp": "1721010138"
//             },
//             "deviceListMetadataVersion": 2
//         }
//     }
// };

// const axios = require('axios');
// // const axios = require('axios');
// async function downloadMedia(req, res) {


//     const mediaUrl = message_image.message.documentMessage.url;
//     const fileName = message_image.message.documentMessage.fileName;

//     const mediaPath = path.join(__dirname, '../media', fileName);

//     try {
//         const response = await axios.get(mediaUrl, { responseType: 'arraybuffer' });
//         fs.writeFileSync(mediaPath, response.data); 
//         return res.status(200).json({ message: 'Media downloaded successfully', mediaPath });
//     }

//     catch (error) {
//         console.error("Error downloading media:", error);
//         return res.status(500).json({ error: 'Internal server error' });
//     }

// }

async function status_chat_customers(req, res) {
    const { session, customer_number, company_id } = req.query;

    if (!session || !customer_number || !company_id) {
        return res.status(400).json({ error: 'Invalid session or customer number' });
    }

    const encryptedSession = encrypt(session);
    const encryptedCustomerNumber = encrypt(customer_number);

    try {
        const chat_history = await chat_history_users.findOne({
            where: {
                session: encryptedSession,
                customer_number: encryptedCustomerNumber,
                company_id: company_id
            }
        });

        if (!chat_history) {
            return res.status(404).json({ error: 'Chat history not found' });
        }

        return res.status(200).json({ chat_history });

    }

    catch (error) {
        console.error("Error fetching chat history:", error);
        return res.status(500).json({ error: 'Internal server error' });
    }
}



module.exports = { connectToWhatsApp,
                sendMessage, 
                isConnected, 
                readChat, 
                broadcast, 
                allChatHistory, 
                InfoNumberWhatsapp, 
                numberOnChatHistory,
                SearchMessage,
                logoutWhatsApp,
                updateProfilePicture,
                deleteMessage,
                startConnections,
                initializeConnections,
                sockets,
                isSessionActive,
                deleteMessage,
                cancelBroadcast,
                editBroadcast,
                importContacts,
                deleteDevices,
                rescheduleJobs,
                readDataEncryptedFile,
                readEncryptedFile,
                downloadProfilePicture,
                searchDataMessage,
                importM,
                delete_alocation_chat,
                add_alocation_chat,
                resetUnreadCount,
                all_chat_sync_logs,
                detail_allocation_chat,
                countUnreadCount,
                // downloadMedia,
                status_chat_customers,
         
};